/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.credential;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Optional;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.crypto.hash.format.Shiro2CryptFormat;
import org.apache.shiro.lang.codec.Base64;
import org.apache.shiro.lang.codec.CodecSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCredentialsMatcher
extends CodecSupport
implements CredentialsMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleCredentialsMatcher.class);
    private static final int DEFAULT_PASSWORD_BYTES = 18;

    protected Object getCredentials(AuthenticationToken token) {
        return token.getCredentials();
    }

    protected Object getCredentials(AuthenticationInfo info) {
        return info.getCredentials();
    }

    protected boolean equals(Object tokenCredentials, Object accountCredentials) {
        if (LOGGER.isDebugEnabled() && tokenCredentials != null) {
            LOGGER.debug("Performing credentials equality check for tokenCredentials of type [" + tokenCredentials.getClass().getName() + " and accountCredentials of type [" + accountCredentials.getClass().getName() + "]");
        }
        if (this.isByteSource(tokenCredentials) && this.isByteSource(accountCredentials)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Both credentials arguments can be easily converted to byte arrays.  Performing array equals comparison");
            }
            byte[] tokenBytes = this.toBytes(tokenCredentials);
            byte[] accountBytes = this.toBytes(accountCredentials);
            return MessageDigest.isEqual(tokenBytes, accountBytes);
        }
        return accountCredentials.equals(tokenCredentials);
    }

    @Override
    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        Object tokenCredentials = this.getCredentials(token);
        Object accountCredentials = this.getCredentials(info);
        return this.equals(tokenCredentials, accountCredentials);
    }

    @Override
    public Optional<AuthenticationInfo> createSimulatedCredentials() {
        return SimpleCredentialsMatcher.makeSimulatedAuthenticationInfo(null);
    }

    static Optional<AuthenticationInfo> makeSimulatedAuthenticationInfo(PasswordService passwordService) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[18];
        random.nextBytes(bytes);
        byte[] encode = Base64.encode((byte[])bytes);
        Object parsedPassword = passwordService == null ? encode : (Object)new Shiro2CryptFormat().parse(passwordService.encryptPassword(encode));
        return Optional.of(new SimpleAuthenticationInfo("__principal__", parsedPassword, ""));
    }
}

