/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

abstract class AbstractSqlppExpressionExtractionVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    protected final LangRewritingContext context;
    protected final Deque<StackElement> stack = new ArrayDeque<StackElement>();

    AbstractSqlppExpressionExtractionVisitor(LangRewritingContext context) {
        this.context = context;
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        List<AbstractClause> letHavingListAfterGby;
        List<AbstractClause> letWhereList;
        StackElement stackElement = new StackElement(selectBlock);
        this.stack.push(stackElement);
        if (selectBlock.hasFromClause()) {
            this.visitFromClause(selectBlock.getFromClause(), arg, stackElement);
        }
        if (!(letWhereList = selectBlock.getLetWhereList()).isEmpty()) {
            this.visitLetWhereClauses(letWhereList, arg, stackElement.extractionList);
        }
        GroupbyClause groupbyClause = null;
        if (selectBlock.hasGroupbyClause()) {
            groupbyClause = selectBlock.getGroupbyClause();
            this.visitGroupByClause(groupbyClause, arg, stackElement.extractionList, letWhereList);
        }
        if (!(letHavingListAfterGby = selectBlock.getLetHavingListAfterGroupby()).isEmpty()) {
            this.visitLetHavingClausesAfterGby(arg, stackElement.extractionList, letHavingListAfterGby, groupbyClause);
        }
        this.visitSelectClause(selectBlock.getSelectClause(), arg, stackElement.extractionList, selectBlock.hasGroupbyClause() ? letHavingListAfterGby : letWhereList, groupbyClause);
        this.stack.pop();
        return null;
    }

    protected void visitFromClause(FromClause clause, ILangExpression arg, StackElement stackElement) throws CompilationException {
        clause.accept(this, arg);
        if (!stackElement.extractionList.isEmpty()) {
            this.handleUnsupportedClause(clause);
        }
    }

    protected void visitLetWhereClauses(List<AbstractClause> letWhereList, ILangExpression arg, List<Pair<Expression, VarIdentifier>> extractionList) throws CompilationException {
        this.visitLetWhereClausesImpl(letWhereList, extractionList, arg);
    }

    protected void visitGroupByClause(GroupbyClause groupbyClause, ILangExpression arg, List<Pair<Expression, VarIdentifier>> extractionList, List<AbstractClause> letWhereList) throws CompilationException {
        groupbyClause.accept((ILangVisitor)this, (Object)arg);
        this.introduceLetClauses(extractionList, letWhereList);
    }

    protected void visitLetHavingClausesAfterGby(ILangExpression arg, List<Pair<Expression, VarIdentifier>> extractionList, List<AbstractClause> letHavingListAfterGby, GroupbyClause groupbyClause) throws CompilationException {
        this.visitLetWhereClausesImpl(letHavingListAfterGby, extractionList, arg);
    }

    protected void visitSelectClause(SelectClause selectClause, ILangExpression arg, List<Pair<Expression, VarIdentifier>> extractionList, List<AbstractClause> letWhereList, GroupbyClause groupbyClause) throws CompilationException {
        selectClause.accept(this, arg);
        this.introduceLetClauses(extractionList, letWhereList);
    }

    private void visitLetWhereClausesImpl(List<AbstractClause> clauseList, List<Pair<Expression, VarIdentifier>> extractionList, ILangExpression arg) throws CompilationException {
        ArrayList<AbstractClause> newClauseList = new ArrayList<AbstractClause>(clauseList.size());
        for (AbstractClause letWhereClause : clauseList) {
            letWhereClause.accept((ILangVisitor)this, (Object)arg);
            this.introduceLetClauses(extractionList, newClauseList);
            newClauseList.add(letWhereClause);
        }
        if (newClauseList.size() > clauseList.size()) {
            clauseList.clear();
            clauseList.addAll(newClauseList);
        }
    }

    private void introduceLetClauses(List<Pair<Expression, VarIdentifier>> fromBindingList, List<AbstractClause> toLetWhereList) {
        for (Pair<Expression, VarIdentifier> p : fromBindingList) {
            Expression bindExpr = (Expression)p.first;
            VarIdentifier var = (VarIdentifier)p.second;
            VariableExpr varExpr = new VariableExpr(var);
            varExpr.setSourceLocation(bindExpr.getSourceLocation());
            toLetWhereList.add((AbstractClause)new LetClause(varExpr, bindExpr));
        }
        fromBindingList.clear();
    }

    abstract void handleUnsupportedClause(FromClause var1) throws CompilationException;

    protected final class StackElement {
        private final SelectBlock selectBlock;
        protected final List<Pair<Expression, VarIdentifier>> extractionList;

        private StackElement(SelectBlock selectBlock) {
            this.selectBlock = selectBlock;
            this.extractionList = new ArrayList<Pair<Expression, VarIdentifier>>();
        }

        public SelectBlock getSelectBlock() {
            return this.selectBlock;
        }

        public VarIdentifier addPendingLetClause(Expression expression) {
            VarIdentifier letVar = AbstractSqlppExpressionExtractionVisitor.this.context.newVariable();
            this.extractionList.add((Pair<Expression, VarIdentifier>)new Pair((Object)expression, (Object)letVar));
            return letVar;
        }
    }
}

