/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.function.Function;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;

public class StorageProperties
extends AbstractProperties {
    private static final int SYSTEM_RESERVED_DATASETS = 0;

    public StorageProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public int getBufferCachePageSize() {
        return this.accessor.getInt(Option.STORAGE_BUFFERCACHE_PAGESIZE);
    }

    public long getBufferCacheSize() {
        return this.accessor.getLong(Option.STORAGE_BUFFERCACHE_SIZE);
    }

    public int getBufferCacheMaxOpenFiles() {
        return this.accessor.getInt(Option.STORAGE_BUFFERCACHE_MAXOPENFILES);
    }

    public int getMemoryComponentPageSize() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_PAGESIZE);
    }

    public double getMemoryComponentFlushThreshold() {
        return this.accessor.getDouble(Option.STORAGE_MEMORYCOMPONENT_FLUSH_THRESHOLD);
    }

    public int getFilteredMemoryComponentMaxNumPages() {
        return (int)(this.accessor.getLong(Option.STORAGE_FILTERED_MEMORYCOMPONENT_MAX_SIZE) / (long)this.getMemoryComponentPageSize());
    }

    public int getMemoryComponentsNum() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS);
    }

    public long getMemoryComponentGlobalBudget() {
        return this.accessor.getLong(Option.STORAGE_MEMORYCOMPONENT_GLOBALBUDGET);
    }

    public double getBloomFilterFalsePositiveRate() {
        return this.accessor.getDouble(Option.STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE);
    }

    public int getBufferCacheNumPages() {
        return (int)(this.getBufferCacheSize() / (long)(this.getBufferCachePageSize() + 8));
    }

    public int getMaxConcurrentFlushes() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_MAX_CONCURRENT_FLUSHES);
    }

    public long getJobExecutionMemoryBudget() {
        long jobExecutionMemory = Runtime.getRuntime().maxMemory() - this.getBufferCacheSize() - this.getMemoryComponentGlobalBudget();
        if (jobExecutionMemory <= 0L) {
            String msg = String.format("Invalid node memory configuration, more memory budgeted than available in JVM. Runtime max memory: (%d), Buffer cache memory (%d), memory component global budget (%d)", Runtime.getRuntime().maxMemory(), this.getBufferCacheSize(), this.getMemoryComponentGlobalBudget());
            throw new IllegalStateException(msg);
        }
        return jobExecutionMemory;
    }

    public String getCompressionScheme() {
        return this.accessor.getString(Option.STORAGE_COMPRESSION_BLOCK);
    }

    public String getIoScheduler() {
        return this.accessor.getString(Option.STORAGE_IO_SCHEDULER);
    }

    protected int getMetadataDatasets() {
        return 15;
    }

    protected int geSystemReservedDatasets() {
        return 0;
    }

    public int getDiskForcePages() {
        return (int)(this.accessor.getLong(Option.STORAGE_DISK_FORCE_BYTES) / (long)this.getBufferCachePageSize());
    }

    public static enum Option implements IOption
    {
        STORAGE_BUFFERCACHE_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE)),
        STORAGE_BUFFERCACHE_SIZE(OptionTypes.LONG_BYTE_UNIT, Runtime.getRuntime().maxMemory() / 4L),
        STORAGE_BUFFERCACHE_MAXOPENFILES(OptionTypes.UNSIGNED_INTEGER, Integer.MAX_VALUE),
        STORAGE_MEMORYCOMPONENT_GLOBALBUDGET(OptionTypes.LONG_BYTE_UNIT, Runtime.getRuntime().maxMemory() / 4L),
        STORAGE_MEMORYCOMPONENT_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE)),
        STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS(OptionTypes.POSITIVE_INTEGER, 2),
        STORAGE_MEMORYCOMPONENT_FLUSH_THRESHOLD(OptionTypes.DOUBLE, 0.9),
        STORAGE_MEMORYCOMPONENT_MAX_CONCURRENT_FLUSHES(OptionTypes.INTEGER, 0),
        STORAGE_FILTERED_MEMORYCOMPONENT_MAX_SIZE(OptionTypes.LONG_BYTE_UNIT, 0L),
        STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE(OptionTypes.DOUBLE, 0.01),
        STORAGE_COMPRESSION_BLOCK(OptionTypes.STRING, "snappy"),
        STORAGE_DISK_FORCE_BYTES(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)16L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE)),
        STORAGE_IO_SCHEDULER(OptionTypes.STRING, "greedy");

        private final IOptionType interpreter;
        private final Object defaultValue;

        private <T> Option(IOptionType<T> interpreter, T defaultValue) {
            this.interpreter = interpreter;
            this.defaultValue = defaultValue;
        }

        public Section section() {
            switch (this) {
                case STORAGE_COMPRESSION_BLOCK: 
                case STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE: {
                    return Section.COMMON;
                }
            }
            return Section.NC;
        }

        public String description() {
            switch (this) {
                case STORAGE_BUFFERCACHE_PAGESIZE: {
                    return "The page size in bytes for pages in the buffer cache";
                }
                case STORAGE_BUFFERCACHE_SIZE: {
                    return "The size of memory allocated to the disk buffer cache.  The value should be a multiple of the buffer cache page size.";
                }
                case STORAGE_BUFFERCACHE_MAXOPENFILES: {
                    return "The maximum number of open files in the buffer cache";
                }
                case STORAGE_MEMORYCOMPONENT_GLOBALBUDGET: {
                    return "The size of memory allocated to the memory components.  The value should be a multiple of the memory component page size";
                }
                case STORAGE_MEMORYCOMPONENT_PAGESIZE: {
                    return "The page size in bytes for pages allocated to memory components";
                }
                case STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS: {
                    return "The number of memory components to be used per lsm index";
                }
                case STORAGE_MEMORYCOMPONENT_MAX_CONCURRENT_FLUSHES: {
                    return "The maximum number of concurrent flush operations. 0 means that the value will be calculated as the number of partitions";
                }
                case STORAGE_MEMORYCOMPONENT_FLUSH_THRESHOLD: {
                    return "The memory usage threshold when memory components should be flushed";
                }
                case STORAGE_FILTERED_MEMORYCOMPONENT_MAX_SIZE: {
                    return "The maximum size of a filtered memory component. 0 means that the memory component does not have a maximum size";
                }
                case STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE: {
                    return "The maximum acceptable false positive rate for bloom filters associated with LSM indexes";
                }
                case STORAGE_COMPRESSION_BLOCK: {
                    return "The default compression scheme for the storage";
                }
                case STORAGE_DISK_FORCE_BYTES: {
                    return "The number of bytes before each disk force (fsync)";
                }
                case STORAGE_IO_SCHEDULER: {
                    return "The I/O scheduler for LSM flush and merge operations";
                }
            }
            throw new IllegalStateException("NYI: " + (Object)((Object)this));
        }

        public IOptionType type() {
            return this.interpreter;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public String usageDefaultOverride(IApplicationConfig accessor, Function<IOption, String> optionPrinter) {
            return null;
        }
    }
}

