/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FilteredVariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.NonPropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;

public class IntersectOperator
extends AbstractLogicalOperator {
    private final List<LogicalVariable> outputCompareVars;
    private final List<List<LogicalVariable>> inputCompareVars;
    private final List<LogicalVariable> outputExtraVars;
    private final List<List<LogicalVariable>> inputExtraVars;

    public IntersectOperator(List<LogicalVariable> outputCompareVars, List<List<LogicalVariable>> inputCompareVars) throws AlgebricksException {
        this(outputCompareVars, Collections.emptyList(), inputCompareVars, Collections.emptyList());
    }

    public IntersectOperator(List<LogicalVariable> outputCompareVars, List<LogicalVariable> outputExtraVars, List<List<LogicalVariable>> inputCompareVars, List<List<LogicalVariable>> inputExtraVars) throws AlgebricksException {
        int numCompareVars = outputCompareVars.size();
        for (List<LogicalVariable> vars : inputCompareVars) {
            if (vars.size() == numCompareVars) continue;
            throw AlgebricksException.create((int)8, (Serializable[])new Serializable[0]);
        }
        if (outputExtraVars == null || outputExtraVars.isEmpty()) {
            if (inputExtraVars != null && !inputExtraVars.isEmpty()) {
                throw AlgebricksException.create((int)8, (Serializable[])new Serializable[0]);
            }
        } else {
            if (inputExtraVars == null || inputExtraVars.isEmpty()) {
                throw AlgebricksException.create((int)8, (Serializable[])new Serializable[0]);
            }
            int numExtraVars = outputExtraVars.size();
            for (List<LogicalVariable> vars : inputExtraVars) {
                if (vars.size() == numExtraVars) continue;
                throw AlgebricksException.create((int)8, (Serializable[])new Serializable[0]);
            }
        }
        this.outputCompareVars = new ArrayList<LogicalVariable>(outputCompareVars);
        this.inputCompareVars = new ArrayList<List<LogicalVariable>>(inputCompareVars);
        this.outputExtraVars = new ArrayList<LogicalVariable>();
        if (outputExtraVars != null) {
            this.outputExtraVars.addAll(outputExtraVars);
        }
        this.inputExtraVars = new ArrayList<List<LogicalVariable>>();
        if (inputExtraVars != null) {
            this.inputExtraVars.addAll(inputExtraVars);
        }
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.INTERSECT;
    }

    @Override
    public void recomputeSchema() {
        this.schema = this.concatOutputVariables();
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform transform) throws AlgebricksException {
        return false;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitIntersectOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new FilteredVariablePropagationPolicy(this.concatOutputVariables());
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        IVariableTypeEnvironment typeEnv = ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue());
        List<LogicalVariable> inputCompareVars0 = this.inputCompareVars.get(0);
        int n = this.inputs.size();
        for (int i = 1; i < n; ++i) {
            this.checkTypeConsistency(typeEnv, inputCompareVars0, ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(i)).getValue()), this.inputCompareVars.get(i));
        }
        NonPropagatingTypeEnvironment env = new NonPropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMetadataProvider());
        int n2 = this.outputCompareVars.size();
        for (int i = 0; i < n2; ++i) {
            env.setVarType(this.outputCompareVars.get(i), typeEnv.getVarType(inputCompareVars0.get(i)));
        }
        if (this.hasExtraVariables()) {
            List<LogicalVariable> inputExtraVars0 = this.inputExtraVars.get(0);
            int n3 = this.outputExtraVars.size();
            for (int i = 0; i < n3; ++i) {
                env.setVarType(this.outputExtraVars.get(i), typeEnv.getVarType(inputExtraVars0.get(i)));
            }
        }
        return env;
    }

    public int getNumInput() {
        return this.inputCompareVars.size();
    }

    public boolean hasExtraVariables() {
        return !this.outputExtraVars.isEmpty();
    }

    public List<LogicalVariable> getInputCompareVariables(int inputIndex) {
        return this.inputCompareVars.get(inputIndex);
    }

    public List<LogicalVariable> getInputExtraVariables(int inputIndex) {
        return this.inputExtraVars.get(inputIndex);
    }

    public List<List<LogicalVariable>> getAllInputsCompareVariables() {
        return this.inputCompareVars;
    }

    public List<List<LogicalVariable>> getAllInputsExtraVariables() {
        return this.inputExtraVars;
    }

    public List<LogicalVariable> getOutputCompareVariables() {
        return this.outputCompareVars;
    }

    public List<LogicalVariable> getOutputExtraVariables() {
        return this.outputExtraVars;
    }

    private List<LogicalVariable> concatOutputVariables() {
        return ListUtils.union(this.outputCompareVars, this.outputExtraVars);
    }

    private void checkTypeConsistency(IVariableTypeEnvironment expected, List<LogicalVariable> expectedVariables, IVariableTypeEnvironment actual, List<LogicalVariable> actualVariables) throws AlgebricksException {
        for (int i = 0; i < expectedVariables.size(); ++i) {
            Object actualType;
            Object expectedType = expected.getVarType(expectedVariables.get(i));
            if (expectedType.equals(actualType = actual.getVarType(actualVariables.get(i))) || !AlgebricksConfig.ALGEBRICKS_LOGGER.isWarnEnabled()) continue;
            AlgebricksConfig.ALGEBRICKS_LOGGER.warn("Type of two variables are not equal." + expectedVariables.get(i) + " is of type: " + expectedType + actualVariables.get(i) + " is of type: " + actualType);
        }
    }
}

