/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.misc.SinkOperatorDescriptor;

public class SinkPOperator
extends AbstractPhysicalOperator {
    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.SINK;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        ArrayList<ILocalStructuralProperty> propsLocal = new ArrayList<ILocalStructuralProperty>();
        IPhysicalPropertiesVector childsProperties = null;
        for (int i = 0; i < op.getInputs().size(); ++i) {
            AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(i).getValue();
            childsProperties = op2.getPhysicalOperator().getDeliveredProperties();
            if (childsProperties.getLocalProperties() == null) continue;
            propsLocal.addAll(childsProperties.getLocalProperties());
        }
        this.deliveredProperties = new StructuralPropertiesVector(childsProperties.getPartitioningProperty(), propsLocal);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        return this.emptyUnaryRequirements(op.getInputs().size());
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        JobSpecification spec = builder.getJobSpec();
        SinkOperatorDescriptor opDesc = new SinkOperatorDescriptor((IOperatorDescriptorRegistry)spec, op.getInputs().size());
        opDesc.setSourceLocation(op.getSourceLocation());
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, (IOperatorDescriptor)opDesc);
        for (int i = 0; i < op.getInputs().size(); ++i) {
            builder.contributeGraphEdge((ILogicalOperator)op.getInputs().get(i).getValue(), 0, op, i);
        }
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }
}

