/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FeedConnectionTupleTranslator
extends AbstractTupleTranslator<FeedConnection> {
    private static final int FEED_CONNECTION_PAYLOAD_TUPLE_FIELD_INDEX = 3;

    public FeedConnectionTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, 3);
    }

    @Override
    protected FeedConnection createMetadataEntityFromARecord(ARecord feedConnectionRecord) throws AlgebricksException {
        int whereClauseIdx;
        String dataverseCanonicalName = ((AString)feedConnectionRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String feedName = ((AString)feedConnectionRecord.getValueByPos(1)).getStringValue();
        String datasetName = ((AString)feedConnectionRecord.getValueByPos(2)).getStringValue();
        String outputType = ((AString)feedConnectionRecord.getValueByPos(3)).getStringValue();
        String policyName = ((AString)feedConnectionRecord.getValueByPos(5)).getStringValue();
        ArrayList<FunctionSignature> appliedFunctions = null;
        IAObject o = feedConnectionRecord.getValueByPos(4);
        if (!(o instanceof ANull) && !(o instanceof AMissing)) {
            appliedFunctions = new ArrayList<FunctionSignature>();
            AUnorderedList afList = (AUnorderedList)feedConnectionRecord.getValueByPos(4);
            IACursor cursor = afList.getCursor();
            while (cursor.next()) {
                String afValue = ((AString)cursor.get()).getStringValue();
                int pos = afValue.lastIndexOf(46);
                String afDataverseCanonicalName = afValue.substring(0, pos);
                String afName = afValue.substring(pos + 1);
                DataverseName afDataverseName = DataverseName.createFromCanonicalForm((String)afDataverseCanonicalName);
                FunctionSignature functionSignature = new FunctionSignature(afDataverseName, afName, 1);
                appliedFunctions.add(functionSignature);
            }
        }
        String whereClauseBody = (whereClauseIdx = feedConnectionRecord.getType().getFieldIndex("WhereClause")) >= 0 ? ((AString)feedConnectionRecord.getValueByPos(whereClauseIdx)).getStringValue() : "";
        return new FeedConnection(dataverseName, feedName, datasetName, appliedFunctions, policyName, whereClauseBody, outputType);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FeedConnection feedConnection) throws HyracksDataException {
        String dataverseCanonicalName = feedConnection.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(feedConnection.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(feedConnection.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.FEED_CONNECTION_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedConnection.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedConnection.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedConnection.getOutputType());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.writeAppliedFunctionsField(this.recordBuilder, feedConnection, this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedConnection.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.writeOpenFields(feedConnection);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(FeedConnection feedConnection) throws HyracksDataException {
        this.writeWhereClauseBody(feedConnection);
    }

    private void writeWhereClauseBody(FeedConnection feedConnection) throws HyracksDataException {
        if (feedConnection.getWhereClauseBody() != null && feedConnection.getWhereClauseBody().length() > 0) {
            this.fieldName.reset();
            this.aString.setValue("WhereClause");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(feedConnection.getWhereClauseBody());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    private void writeAppliedFunctionsField(IARecordBuilder rb, FeedConnection fc, ArrayBackedValueStorage buffer) throws HyracksDataException {
        UnorderedListBuilder listBuilder = new UnorderedListBuilder();
        ArrayBackedValueStorage listEleBuffer = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)((AUnorderedListType)MetadataRecordTypes.FEED_CONNECTION_RECORDTYPE.getFieldTypes()[4]));
        if (fc.getAppliedFunctions() != null) {
            List<FunctionSignature> appliedFunctions = fc.getAppliedFunctions();
            for (FunctionSignature af : appliedFunctions) {
                listEleBuffer.reset();
                this.aString.setValue(af.getDataverseName().getCanonicalForm() + "." + af.getName());
                this.stringSerde.serialize((Object)this.aString, listEleBuffer.getDataOutput());
                listBuilder.addItem((IValueReference)listEleBuffer);
            }
        }
        listBuilder.write(buffer.getDataOutput(), true);
        rb.addField(4, (IValueReference)buffer);
    }
}

