/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;

public class WriteResultPOperator
extends AbstractPhysicalOperator {
    private LogicalVariable payload;
    private List<LogicalVariable> keys;
    private IDataSource<?> dataSource;
    private final List<LogicalVariable> additionalFilteringKeys;

    public WriteResultPOperator(IDataSource<?> dataSource, LogicalVariable payload, List<LogicalVariable> keys, List<LogicalVariable> additionalFilteringKeys) {
        this.dataSource = dataSource;
        this.payload = payload;
        this.keys = keys;
        this.additionalFilteringKeys = additionalFilteringKeys;
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + " " + this.payload + " " + this.keys;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.WRITE_RESULT;
    }

    @Override
    public boolean isMicroOperator() {
        return true;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        this.deliveredProperties = (StructuralPropertiesVector)op2.getDeliveredPhysicalProperties().clone();
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        ArrayList<LogicalVariable> scanVariables = new ArrayList<LogicalVariable>();
        scanVariables.addAll(this.keys);
        scanVariables.add(new LogicalVariable(-1));
        IPhysicalPropertiesVector r = this.dataSource.getPropertiesProvider().computePropertiesVector(scanVariables);
        IPhysicalPropertiesVector[] requirements = new IPhysicalPropertiesVector[]{r};
        return new PhysicalRequirements(requirements, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        WriteResultOperator writeResultOp = (WriteResultOperator)op;
        IMetadataProvider<?, ?> mp = context.getMetadataProvider();
        JobSpecification spec = builder.getJobSpec();
        Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> runtimeAndConstraints = mp.getWriteResultRuntime(this.dataSource, propagatedSchema, this.keys, this.payload, this.additionalFilteringKeys, context, spec);
        IOperatorDescriptor opDesc = (IOperatorDescriptor)runtimeAndConstraints.first;
        opDesc.setSourceLocation(writeResultOp.getSourceLocation());
        builder.contributeHyracksOperator(writeResultOp, opDesc);
        builder.contributeAlgebricksPartitionConstraint(opDesc, (AlgebricksPartitionConstraint)runtimeAndConstraints.second);
        ILogicalOperator src = (ILogicalOperator)writeResultOp.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, writeResultOp, 0);
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }
}

