/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutObjectLockConfigurationResponse
extends S3Response
implements ToCopyableBuilder<Builder, PutObjectLockConfigurationResponse> {
    private static final SdkField<String> REQUEST_CHARGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutObjectLockConfigurationResponse.getter(PutObjectLockConfigurationResponse::requestChargedAsString)).setter(PutObjectLockConfigurationResponse.setter(Builder::requestCharged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-request-charged").unmarshallLocationName("x-amz-request-charged").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_CHARGED_FIELD));
    private final String requestCharged;

    private PutObjectLockConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.requestCharged = builder.requestCharged;
    }

    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(this.requestCharged);
    }

    public String requestChargedAsString() {
        return this.requestCharged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestChargedAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectLockConfigurationResponse)) {
            return false;
        }
        PutObjectLockConfigurationResponse other = (PutObjectLockConfigurationResponse)((Object)obj);
        return Objects.equals(this.requestChargedAsString(), other.requestChargedAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutObjectLockConfigurationResponse").add("RequestCharged", (Object)this.requestChargedAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestCharged": {
                return Optional.ofNullable(clazz.cast(this.requestChargedAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectLockConfigurationResponse, T> g) {
        return obj -> g.apply((PutObjectLockConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectLockConfigurationResponse model) {
            super(model);
            this.requestCharged(model.requestCharged);
        }

        public final String getRequestChargedAsString() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged == null ? null : requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        @Override
        public PutObjectLockConfigurationResponse build() {
            return new PutObjectLockConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutObjectLockConfigurationResponse> {
        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);
    }
}

