/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.dataflow.AbstractDataFlowController;
import org.apache.asterix.external.dataflow.TupleForwarder;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.tuples.ReferenceFrameTupleReference;

public class StreamDataFlowController
extends AbstractDataFlowController {
    private final IStreamDataParser dataParser;

    public StreamDataFlowController(IHyracksTaskContext ctx, IStreamDataParser dataParser) {
        super(ctx);
        this.dataParser = dataParser;
    }

    @Override
    public void start(IFrameWriter writer, ITupleFilter tupleFilter, long outputLimit) throws HyracksDataException {
        try {
            this.processedTuples = 0L;
            ArrayTupleBuilder tb = new ArrayTupleBuilder(1);
            boolean tupleFilterExists = tupleFilter != null;
            ArrayTupleReference tupleRef = tupleFilterExists ? new ArrayTupleReference() : null;
            ReferenceFrameTupleReference frameTupleRef = tupleFilterExists ? new ReferenceFrameTupleReference() : null;
            TupleForwarder tupleForwarder = new TupleForwarder(this.ctx, writer);
            while (outputLimit < 0L || this.processedTuples < outputLimit) {
                tb.reset();
                if (!this.dataParser.parse(tb.getDataOutput())) break;
                tb.addFieldEndOffset();
                if (tupleFilterExists) {
                    tupleRef.reset(tb.getFieldEndOffsets(), tb.getByteArray());
                    frameTupleRef.reset((ITupleReference)tupleRef);
                    if (!tupleFilter.accept((IFrameTupleReference)frameTupleRef)) continue;
                }
                tupleForwarder.addTuple(tb);
                ++this.processedTuples;
            }
            tupleForwarder.complete();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

