/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABinary;
import org.apache.asterix.om.base.AMutableBinary;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.aggregates.base.AbstractAggregateFunctionDynamicDescriptor;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;

public class LocalSamplingAggregateDescriptor
extends AbstractAggregateFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private int numSamples;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new LocalSamplingAggregateDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_NUM_SAMPLES;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.LOCAL_SAMPLING;
    }

    public void setImmutableStates(Object ... states) {
        this.numSamples = (Integer)states[0];
    }

    public IAggregateEvaluatorFactory createAggregateEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IAggregateEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IAggregateEvaluator createAggregateEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new LocalSamplingAggregateFunction(args, ctx, LocalSamplingAggregateDescriptor.this.numSamples, LocalSamplingAggregateDescriptor.this.sourceLoc);
            }
        };
    }

    private static class LocalSamplingAggregateFunction
    extends AbstractAggregateFunction {
        private ISerializerDeserializer<ABinary> binarySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABINARY);
        private final AMutableBinary binary = new AMutableBinary(null, 0, 0);
        private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
        private final ArrayBackedValueStorage rangeMapBits = new ArrayBackedValueStorage();
        private final IPointable inputFieldValue = new VoidPointable();
        private final int numSamplesRequired;
        private final IScalarEvaluator[] sampledFieldsEval;
        private final ArrayList<ArrayBackedValueStorage> samples = new ArrayList();
        private final Random random = new Random();
        private int count = 0;

        private LocalSamplingAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, int numSamples, SourceLocation srcLoc) throws HyracksDataException {
            super(srcLoc);
            this.sampledFieldsEval = new IScalarEvaluator[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.sampledFieldsEval[i] = args[i].createScalarEvaluator(context);
            }
            this.numSamplesRequired = numSamples > 0 ? numSamples : (Integer)CompilerProperties.Option.COMPILER_SORT_SAMPLES.defaultValue();
        }

        public void init() throws HyracksDataException {
            this.samples.clear();
            this.count = 0;
            this.rangeMapBits.reset();
        }

        public void step(IFrameTupleReference tuple) throws HyracksDataException {
            ++this.count;
            if (this.samples.size() < this.numSamplesRequired) {
                ArrayBackedValueStorage sampleStorage = new ArrayBackedValueStorage();
                this.writeTupleKey(tuple, sampleStorage);
                this.samples.add(sampleStorage);
                return;
            }
            int swap = this.random.nextInt(this.count);
            if (swap < this.numSamplesRequired) {
                this.writeTupleKey(tuple, this.samples.get(swap));
            }
        }

        private void writeTupleKey(IFrameTupleReference tuple, ArrayBackedValueStorage storage) throws HyracksDataException {
            storage.reset();
            for (IScalarEvaluator iScalarEvaluator : this.sampledFieldsEval) {
                iScalarEvaluator.evaluate(tuple, this.inputFieldValue);
                IntegerSerializerDeserializer.write((int)this.inputFieldValue.getLength(), (DataOutput)storage.getDataOutput());
                storage.append((IValueReference)this.inputFieldValue);
            }
        }

        public void finish(IPointable result) throws HyracksDataException {
            this.storage.reset();
            if (this.samples.size() == 0) {
                try {
                    this.storage.getDataOutput().writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
                    result.set((IValueReference)this.storage);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            } else {
                this.rangeMapBits.reset();
                IntegerSerializerDeserializer.write((int)this.samples.size(), (DataOutput)this.rangeMapBits.getDataOutput());
                for (ArrayBackedValueStorage sample : this.samples) {
                    this.rangeMapBits.append((IValueReference)sample);
                }
                this.binary.setValue(this.rangeMapBits.getByteArray(), this.rangeMapBits.getStartOffset(), this.rangeMapBits.getLength());
                this.binarySerde.serialize((Object)this.binary, this.storage.getDataOutput());
                result.set((IValueReference)this.storage);
            }
        }

        public void finishPartial(IPointable result) throws HyracksDataException {
            this.finish(result);
        }
    }
}

