/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Synonym
implements IMetadataEntity<Synonym> {
    private static final long serialVersionUID = 1L;
    private final DataverseName dataverseName;
    private final String synonymName;
    private final DataverseName objectDataverseName;
    private final String objectName;

    public Synonym(DataverseName dataverseName, String synonymName, DataverseName objectDataverseName, String objectName) {
        this.dataverseName = Objects.requireNonNull(dataverseName);
        this.synonymName = Objects.requireNonNull(synonymName);
        this.objectDataverseName = Objects.requireNonNull(objectDataverseName);
        this.objectName = Objects.requireNonNull(objectName);
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getSynonymName() {
        return this.synonymName;
    }

    public DataverseName getObjectDataverseName() {
        return this.objectDataverseName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Synonym synonym = (Synonym)o;
        return this.dataverseName.equals((Object)synonym.dataverseName) && this.synonymName.equals(synonym.synonymName) && this.objectDataverseName.equals((Object)synonym.objectDataverseName) && this.objectName.equals(synonym.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.dataverseName, this.synonymName, this.objectDataverseName, this.objectName);
    }

    @Override
    public Synonym addToCache(MetadataCache cache) {
        return cache.addSynonymIfNotExists(this);
    }

    @Override
    public Synonym dropFromCache(MetadataCache cache) {
        return cache.dropSynonym(this);
    }
}

