/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractIoOperation;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;

public abstract class MergeOperation
extends AbstractIoOperation {
    protected final IIndexCursor cursor;
    protected final IIndexCursorStats stats;
    protected final long totalPages;

    public MergeOperation(ILSMIndexAccessor accessor, FileReference target, ILSMIOOperationCallback callback, String indexIdentifier, IIndexCursor cursor, IIndexCursorStats stats) {
        super(accessor, target, callback, indexIdentifier);
        this.cursor = cursor;
        this.stats = stats;
        this.totalPages = this.computeTotalComponentPages(accessor);
    }

    public List<ILSMComponent> getMergingComponents() {
        return this.accessor.getOpContext().getComponentHolder();
    }

    @Override
    public ILSMIOOperation.LSMIOOperationStatus call() throws HyracksDataException {
        this.accessor.merge(this);
        return this.getStatus();
    }

    @Override
    public ILSMIOOperation.LSMIOOperationType getIOOpertionType() {
        return ILSMIOOperation.LSMIOOperationType.MERGE;
    }

    public IIndexCursor getCursor() {
        return this.cursor;
    }

    private long computeTotalComponentPages(ILSMIndexAccessor accessor) {
        List<ILSMDiskComponent> components = accessor.getOpContext().getComponentsToBeMerged();
        long totalSize = 0L;
        for (ILSMDiskComponent component : components) {
            long componentSize = component.getComponentSize();
            if (component instanceof AbstractLSMWithBloomFilterDiskComponent) {
                componentSize -= ((AbstractLSMWithBloomFilterDiskComponent)component).getBloomFilter().getFileReference().getFile().length();
            }
            totalSize += componentSize;
        }
        return totalSize / (long)accessor.getOpContext().getIndex().getBufferCache().getPageSize();
    }

    @Override
    public long getRemainingPages() {
        return this.totalPages - this.stats.getPageCounter().get();
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public IIndexCursorStats getCursorStats() {
        return this.stats;
    }
}

