/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;

public abstract class TypePropagationPolicy {
    public static final TypePropagationPolicy ALL = new TypePropagationPolicy(){

        @Override
        public Object getVarType(LogicalVariable var, IMissableTypeComputer ntc, List<LogicalVariable> nonMissableVariableList, List<List<LogicalVariable>> correlatedMissableVariableLists, List<LogicalVariable> nonNullableVariableList, List<List<LogicalVariable>> correlatedNullableVariableLists, ITypeEnvPointer ... typeEnvs) throws AlgebricksException {
            for (ITypeEnvPointer p : typeEnvs) {
                boolean makeNonNullable;
                IVariableTypeEnvironment env = p.getTypeEnv();
                if (env == null) {
                    throw new AlgebricksException("Null environment for pointer " + p + " in getVarType for var=" + var);
                }
                Object t = env.getVarType(var, nonMissableVariableList, correlatedMissableVariableLists, nonNullableVariableList, correlatedNullableVariableLists);
                if (t == null) continue;
                boolean makeNonMissable = !nonMissableVariableList.isEmpty() && ntc.canBeMissing(t) && nonMissableVariableList.contains(var);
                boolean bl = makeNonNullable = !nonNullableVariableList.isEmpty() && ntc.canBeNull(t) && nonNullableVariableList.contains(var);
                if (makeNonMissable && makeNonNullable) {
                    return ntc.getNonOptionalType(t);
                }
                if (makeNonMissable) {
                    return ntc.getNonMissableType(t);
                }
                if (makeNonNullable) {
                    return ntc.getNonNullableType(t);
                }
                return t;
            }
            return null;
        }
    };

    public abstract Object getVarType(LogicalVariable var1, IMissableTypeComputer var2, List<LogicalVariable> var3, List<List<LogicalVariable>> var4, List<LogicalVariable> var5, List<List<LogicalVariable>> var6, ITypeEnvPointer ... var7) throws AlgebricksException;
}

