/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.dataflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.compression.ICompressorDecompressorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.lsm.btree.utils.LSMBTreeUtil;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LsmResource;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.compression.NoOpCompressorDecompressorFactory;

public class LSMBTreeLocalResource
extends LsmResource {
    private static final long serialVersionUID = 1L;
    private static final String HAS_BLOOM_FILTER_FIELD = "hasBloomFilter";
    protected final boolean hasBloomFilter;
    protected final int[] bloomFilterKeyFields;
    protected final double bloomFilterFalsePositiveRate;
    protected final boolean isPrimary;
    protected final int[] btreeFields;
    protected final ICompressorDecompressorFactory compressorDecompressorFactory;
    protected final boolean isSecondaryNoIncrementalMaintenance;

    public LSMBTreeLocalResource(ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, int[] bloomFilterKeyFields, double bloomFilterFalsePositiveRate, boolean isPrimary, String path, IStorageManager storageManager, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] btreeFields, int[] filterFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory, IVirtualBufferCacheProvider vbcProvider, ILSMIOOperationSchedulerProvider ioSchedulerProvider, boolean durable, ICompressorDecompressorFactory compressorDecompressorFactory, boolean hasBloomFilter, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector, boolean isSecondaryNoIncrementalMaintenance) {
        super(path, storageManager, typeTraits, cmpFactories, filterTypeTraits, filterCmpFactories, filterFields, opTrackerProvider, ioOpCallbackFactory, pageWriteCallbackFactory, metadataPageManagerFactory, vbcProvider, ioSchedulerProvider, mergePolicyFactory, mergePolicyProperties, durable, nullTypeTraits, nullIntrospector);
        this.bloomFilterKeyFields = bloomFilterKeyFields;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
        this.isPrimary = isPrimary;
        this.btreeFields = btreeFields;
        this.compressorDecompressorFactory = compressorDecompressorFactory;
        this.hasBloomFilter = hasBloomFilter;
        this.isSecondaryNoIncrementalMaintenance = isSecondaryNoIncrementalMaintenance;
    }

    protected LSMBTreeLocalResource(IPersistedResourceRegistry registry, JsonNode json, int[] bloomFilterKeyFields, double bloomFilterFalsePositiveRate, boolean isPrimary, int[] btreeFields, ICompressorDecompressorFactory compressorDecompressorFactory, boolean hasBloomFilter, boolean isSecondaryNoIncrementalMaintenance) throws HyracksDataException {
        super(registry, json);
        this.bloomFilterKeyFields = bloomFilterKeyFields;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
        this.isPrimary = isPrimary;
        this.btreeFields = btreeFields;
        this.compressorDecompressorFactory = compressorDecompressorFactory;
        this.hasBloomFilter = hasBloomFilter;
        this.isSecondaryNoIncrementalMaintenance = isSecondaryNoIncrementalMaintenance;
    }

    public ILSMIndex createInstance(INCServiceContext serviceCtx) throws HyracksDataException {
        IIOManager ioManager = serviceCtx.getIoManager();
        FileReference file = ioManager.resolve(this.path);
        List vbcs = this.vbcProvider.getVirtualBufferCaches(serviceCtx, file);
        this.ioOpCallbackFactory.initialize(serviceCtx, (IResource)this);
        this.pageWriteCallbackFactory.initialize(serviceCtx, (IResource)this);
        boolean updateAware = false;
        return LSMBTreeUtil.createLSMTree(ioManager, vbcs, file, this.storageManager.getBufferCache(serviceCtx), this.typeTraits, this.cmpFactories, this.bloomFilterKeyFields, this.bloomFilterFalsePositiveRate, this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, serviceCtx), this.opTrackerProvider.getOperationTracker(serviceCtx, (IResource)this), this.ioSchedulerProvider.getIoScheduler(serviceCtx), this.ioOpCallbackFactory, this.pageWriteCallbackFactory, this.isPrimary, this.filterTypeTraits, this.filterCmpFactories, this.btreeFields, this.filterFields, this.durable, this.metadataPageManagerFactory, updateAware, serviceCtx.getTracer(), this.compressorDecompressorFactory, this.hasBloomFilter, this.nullTypeTraits, this.nullIntrospector);
    }

    public boolean isSecondaryNoIncrementalMaintenance() {
        return this.isSecondaryNoIncrementalMaintenance;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode jsonObject = registry.getClassIdentifier(((Object)((Object)this)).getClass(), 1L);
        this.appendToJson(jsonObject, registry);
        return jsonObject;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        int[] bloomFilterKeyFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("bloomFilterKeyFields"), int[].class);
        double bloomFilterFalsePositiveRate = json.get("bloomFilterFalsePositiveRate").asDouble();
        boolean isPrimary = json.get("isPrimary").asBoolean();
        boolean hasBloomFilter = LSMBTreeLocalResource.getOrDefaultHasBloomFilter(json, isPrimary);
        int[] btreeFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("btreeFields"), int[].class);
        JsonNode compressorDecompressorNode = json.get("compressorDecompressorFactory");
        ICompressorDecompressorFactory compDecompFactory = (ICompressorDecompressorFactory)registry.deserializeOrDefault(compressorDecompressorNode, NoOpCompressorDecompressorFactory.class);
        boolean isSecondaryNoIncrementalMaintenance = LSMBTreeLocalResource.getOrDefaultBoolean(json, "isSecondaryNoIncrementalMaintenance", false);
        return new LSMBTreeLocalResource(registry, json, bloomFilterKeyFields, bloomFilterFalsePositiveRate, isPrimary, btreeFields, compDecompFactory, hasBloomFilter, isSecondaryNoIncrementalMaintenance);
    }

    protected void appendToJson(ObjectNode json, IPersistedResourceRegistry registry) throws HyracksDataException {
        super.appendToJson(json, registry);
        json.put(HAS_BLOOM_FILTER_FIELD, this.hasBloomFilter);
        json.putPOJO("bloomFilterKeyFields", (Object)this.bloomFilterKeyFields);
        json.put("bloomFilterFalsePositiveRate", this.bloomFilterFalsePositiveRate);
        json.put("isPrimary", this.isPrimary);
        json.putPOJO("btreeFields", (Object)this.btreeFields);
        json.putPOJO("compressorDecompressorFactory", (Object)this.compressorDecompressorFactory.toJson(registry));
        json.put("isSecondaryNoIncrementalMaintenance", this.isSecondaryNoIncrementalMaintenance);
    }

    private static boolean getOrDefaultHasBloomFilter(JsonNode json, boolean isPrimary) {
        return LSMBTreeLocalResource.getOrDefaultBoolean(json, HAS_BLOOM_FILTER_FIELD, isPrimary);
    }

    private static boolean getOrDefaultBoolean(JsonNode jsonNode, String fieldName, boolean defaultValue) {
        return jsonNode.has(fieldName) ? jsonNode.get(fieldName).asBoolean() : defaultValue;
    }
}

