/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ILSMIndexCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponentScanCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class LSMBTreeSearchCursor
extends EnforcedIndexCursor
implements ILSMIndexCursor {
    private final LSMBTreePointSearchCursor pointCursor;
    private final LSMBTreeRangeSearchCursor rangeCursor;
    private final LSMBTreeDiskComponentScanCursor scanCursor;
    private ILSMIndexCursor currentCursor;

    public LSMBTreeSearchCursor(ILSMIndexOperationContext opCtx) {
        this.pointCursor = new LSMBTreePointSearchCursor(opCtx);
        this.rangeCursor = new LSMBTreeRangeSearchCursor(opCtx);
        this.scanCursor = new LSMBTreeDiskComponentScanCursor(opCtx);
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        RangePredicate btreePred = (RangePredicate)searchPred;
        this.currentCursor = lsmInitialState.isDiskComponentScan() ? this.scanCursor : (btreePred.isPointPredicate(lsmInitialState.getOriginalKeyComparator()) ? this.pointCursor : this.rangeCursor);
        this.currentCursor.open((ICursorInitialState)lsmInitialState, searchPred);
    }

    public boolean doHasNext() throws HyracksDataException {
        return this.currentCursor.hasNext();
    }

    public void doNext() throws HyracksDataException {
        this.currentCursor.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDestroy() throws HyracksDataException {
        try {
            this.pointCursor.destroy();
        }
        finally {
            try {
                this.rangeCursor.destroy();
            }
            finally {
                try {
                    this.scanCursor.destroy();
                }
                finally {
                    this.currentCursor = null;
                }
            }
        }
    }

    public void doClose() throws HyracksDataException {
        if (this.currentCursor != null) {
            this.currentCursor.close();
        }
        this.currentCursor = null;
    }

    public ITupleReference doGetTuple() {
        return this.currentCursor.getTuple();
    }

    public ITupleReference getFilterMinTuple() {
        return this.currentCursor.getFilterMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        return this.currentCursor.getFilterMaxTuple();
    }

    public boolean getSearchOperationCallbackProceedResult() {
        return this.currentCursor.getSearchOperationCallbackProceedResult();
    }

    public static enum LSMBTreeSearchType {
        POINT,
        RANGE;

    }
}

