/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public class ExponentialBackoff
implements RetryStrategy {
    private static final double JITTER_FACTOR = 0.05;
    private static final int DEFAULT_MAX_RETRIES;
    private static final Duration DEFAULT_BASE_DELAY;
    private static final Duration DEFAULT_MAX_DELAY;
    private final int maxRetries;
    private final long baseDelayNanos;
    private final long maxDelayNanos;

    public ExponentialBackoff() {
        this(DEFAULT_MAX_RETRIES, DEFAULT_BASE_DELAY, DEFAULT_MAX_DELAY);
    }

    public ExponentialBackoff(int maxRetries, Duration baseDelay, Duration maxDelay) {
        ClientLogger logger = new ClientLogger(ExponentialBackoff.class);
        if (maxRetries < 0) {
            throw logger.logExceptionAsError(new IllegalArgumentException("Max retries cannot be less than 0."));
        }
        Objects.requireNonNull(baseDelay, "'baseDelay' cannot be null.");
        Objects.requireNonNull(maxDelay, "'maxDelay' cannot be null.");
        if (baseDelay.isZero() || baseDelay.isNegative()) {
            throw logger.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be negative or 0."));
        }
        if (baseDelay.compareTo(maxDelay) > 0) {
            throw logger.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be greater than 'maxDelay'."));
        }
        this.maxRetries = maxRetries;
        this.baseDelayNanos = baseDelay.toNanos();
        this.maxDelayNanos = maxDelay.toNanos();
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Duration calculateRetryDelay(int retryAttempts) {
        long delayWithJitterInNanos = ThreadLocalRandom.current().nextLong((long)((double)this.baseDelayNanos * 0.95), (long)((double)this.baseDelayNanos * 1.05));
        return Duration.ofNanos(Math.min((1L << retryAttempts) * delayWithJitterInNanos, this.maxDelayNanos));
    }

    static {
        DEFAULT_BASE_DELAY = Duration.ofMillis(800L);
        DEFAULT_MAX_DELAY = Duration.ofSeconds(8L);
        String envDefaultMaxRetries = Configuration.getGlobalConfiguration().get("AZURE_REQUEST_RETRY_COUNT");
        int defaultMaxRetries = 3;
        if (!CoreUtils.isNullOrEmpty(envDefaultMaxRetries)) {
            try {
                defaultMaxRetries = Integer.parseInt(envDefaultMaxRetries);
                if (defaultMaxRetries < 0) {
                    defaultMaxRetries = 3;
                }
            }
            catch (NumberFormatException ignored) {
                new ClientLogger(ExponentialBackoff.class).verbose("{} was loaded but is an invalid number. Using 3 retries as the maximum.", "AZURE_REQUEST_RETRY_COUNT");
            }
        }
        DEFAULT_MAX_RETRIES = defaultMaxRetries;
    }
}

