/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.jackson.AdditionalPropertiesDeserializer;
import com.azure.core.implementation.jackson.AdditionalPropertiesSerializer;
import com.azure.core.implementation.jackson.Base64UrlSerializer;
import com.azure.core.implementation.jackson.ByteArraySerializer;
import com.azure.core.implementation.jackson.DateTimeDeserializer;
import com.azure.core.implementation.jackson.DateTimeRfc1123Serializer;
import com.azure.core.implementation.jackson.DateTimeSerializer;
import com.azure.core.implementation.jackson.DurationSerializer;
import com.azure.core.implementation.jackson.FlatteningDeserializer;
import com.azure.core.implementation.jackson.FlatteningSerializer;
import com.azure.core.implementation.jackson.GeoJsonDeserializer;
import com.azure.core.implementation.jackson.GeoJsonSerializer;
import com.azure.core.implementation.jackson.HttpHeadersSerializer;
import com.azure.core.implementation.jackson.UnixTimeDeserializer;
import com.azure.core.implementation.jackson.UnixTimeSerializer;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

final class ObjectMapperFactory {
    private final ClientLogger logger = new ClientLogger(ObjectMapperFactory.class);
    private static final String MUTABLE_COERCION_CONFIG = "com.fasterxml.jackson.databind.cfg.MutableCoercionConfig";
    private static final String COERCION_INPUT_SHAPE = "com.fasterxml.jackson.databind.cfg.CoercionInputShape";
    private static final String COERCION_ACTION = "com.fasterxml.jackson.databind.cfg.CoercionAction";
    private MethodHandle coersionConfigDefaults;
    private MethodHandle setCoercion;
    private Object coercionInputShapeEmptyString;
    private Object coercionActionAsNull;
    private boolean useReflectionToSetCoercion;
    private static ObjectMapperFactory instance;
    public static final ObjectMapperFactory INSTANCE;

    private ObjectMapperFactory() {
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        try {
            Class<?> mutableCoercionConfig = Class.forName(MUTABLE_COERCION_CONFIG);
            Class<?> coercionInputShapeClass = Class.forName(COERCION_INPUT_SHAPE);
            Class<?> coercionActionClass = Class.forName(COERCION_ACTION);
            this.coersionConfigDefaults = publicLookup.findVirtual(ObjectMapper.class, "coercionConfigDefaults", MethodType.methodType(mutableCoercionConfig));
            this.setCoercion = publicLookup.findVirtual(mutableCoercionConfig, "setCoercion", MethodType.methodType(mutableCoercionConfig, coercionInputShapeClass, coercionActionClass));
            this.coercionInputShapeEmptyString = publicLookup.findStaticGetter(coercionInputShapeClass, "EmptyString", coercionInputShapeClass).invoke();
            this.coercionActionAsNull = publicLookup.findStaticGetter(coercionActionClass, "AsNull", coercionActionClass).invoke();
            this.useReflectionToSetCoercion = true;
        }
        catch (Throwable ex) {
            this.logger.verbose("Failed to retrieve MethodHandles used to set coercion configurations. Setting coercion configurations will be skipped.", ex);
        }
    }

    public ObjectMapper createJsonMapper(ObjectMapper innerMapper) {
        ObjectMapper flatteningMapper = ((JsonMapper.Builder)((JsonMapper.Builder)this.initializeMapperBuilder(JsonMapper.builder()).addModule((Module)FlatteningSerializer.getModule(innerMapper))).addModule((Module)FlatteningDeserializer.getModule(innerMapper))).build();
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)this.initializeMapperBuilder(JsonMapper.builder()).addModule((Module)AdditionalPropertiesSerializer.getModule(flatteningMapper))).addModule((Module)AdditionalPropertiesDeserializer.getModule(flatteningMapper))).addModule((Module)FlatteningSerializer.getModule(innerMapper))).addModule((Module)FlatteningDeserializer.getModule(innerMapper))).build();
    }

    public ObjectMapper createXmlMapper() {
        ObjectMapper xmlMapper = this.initializeMapperBuilder(XmlMapper.builder()).defaultUseWrapper(false).enable(new ToXmlGenerator.Feature[]{ToXmlGenerator.Feature.WRITE_XML_DECLARATION}).enable(new FromXmlParser.Feature[]{FromXmlParser.Feature.EMPTY_ELEMENT_AS_NULL}).build();
        if (this.useReflectionToSetCoercion) {
            try {
                Object object = this.coersionConfigDefaults.invoke(xmlMapper);
                this.setCoercion.invoke(object, this.coercionInputShapeEmptyString, this.coercionActionAsNull);
            }
            catch (Throwable e) {
                this.logger.verbose("Failed to set coercion actions.", e);
            }
        } else {
            this.logger.verbose("Didn't set coercion defaults as it wasn't found on the classpath.");
        }
        return xmlMapper;
    }

    public ObjectMapper createSimpleMapper() {
        return this.initializeMapperBuilder(JsonMapper.builder()).build();
    }

    public ObjectMapper createDefaultMapper() {
        return new ObjectMapper();
    }

    public ObjectMapper createPrettyPrintMapper() {
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    }

    public ObjectMapper createHeaderMapper() {
        return ((JsonMapper.Builder)this.initializeMapperBuilder(JsonMapper.builder()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).build();
    }

    private <S extends MapperBuilder<?, ?>> S initializeMapperBuilder(S mapper) {
        mapper.enable(new SerializationFeature[]{SerializationFeature.WRITE_EMPTY_JSON_ARRAYS}).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT}).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS}).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).serializationInclusion(JsonInclude.Include.NON_NULL).addModule((Module)new JavaTimeModule()).addModule((Module)ByteArraySerializer.getModule()).addModule((Module)Base64UrlSerializer.getModule()).addModule((Module)DateTimeSerializer.getModule()).addModule((Module)DateTimeDeserializer.getModule()).addModule((Module)DateTimeRfc1123Serializer.getModule()).addModule((Module)DurationSerializer.getModule()).addModule((Module)HttpHeadersSerializer.getModule()).addModule((Module)UnixTimeSerializer.getModule()).addModule((Module)UnixTimeDeserializer.getModule()).addModule((Module)GeoJsonSerializer.getModule()).addModule((Module)GeoJsonDeserializer.getModule()).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        return mapper;
    }

    static {
        INSTANCE = new ObjectMapperFactory();
    }
}

