/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.ActivityClusterId;
import org.apache.hyracks.api.job.IGlobalJobDataFactory;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;

public class ActivityClusterGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int version = 0;
    private final Map<ActivityClusterId, ActivityCluster> activityClusterMap = new HashMap<ActivityClusterId, ActivityCluster>();
    private final Map<ActivityId, ActivityCluster> activityMap = new HashMap<ActivityId, ActivityCluster>();
    private final Map<ConnectorDescriptorId, ActivityCluster> connectorMap = new HashMap<ConnectorDescriptorId, ActivityCluster>();
    private int frameSize = 32768;
    private long maxWarnings;
    private int maxReattempts;
    private IJobletEventListenerFactory jobletEventListenerFactory;
    private IGlobalJobDataFactory globalJobDataFactory;
    private IConnectorPolicyAssignmentPolicy connectorPolicyAssignmentPolicy;
    private boolean useConnectorPolicyForScheduling;
    private boolean reportTaskDetails = true;

    public Map<ActivityId, ActivityCluster> getActivityMap() {
        return this.activityMap;
    }

    public Map<ConnectorDescriptorId, ActivityCluster> getConnectorMap() {
        return this.connectorMap;
    }

    public Map<ActivityClusterId, ActivityCluster> getActivityClusterMap() {
        return this.activityClusterMap;
    }

    public void addActivityClusters(Collection<ActivityCluster> newActivityClusters) {
        for (ActivityCluster ac : newActivityClusters) {
            this.activityClusterMap.put(ac.getId(), ac);
            for (ActivityId aid : ac.getActivityMap().keySet()) {
                this.activityMap.put(aid, ac);
            }
            for (ConnectorDescriptorId cid : ac.getConnectorMap().keySet()) {
                this.connectorMap.put(cid, ac);
            }
        }
        ++this.version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public void setMaxWarnings(long maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    public long getMaxWarnings() {
        return this.maxWarnings;
    }

    public void setMaxReattempts(int maxReattempts) {
        this.maxReattempts = maxReattempts;
    }

    public int getMaxReattempts() {
        return this.maxReattempts;
    }

    public IJobletEventListenerFactory getJobletEventListenerFactory() {
        return this.jobletEventListenerFactory;
    }

    public void setJobletEventListenerFactory(IJobletEventListenerFactory jobletEventListenerFactory) {
        this.jobletEventListenerFactory = jobletEventListenerFactory;
    }

    public IGlobalJobDataFactory getGlobalJobDataFactory() {
        return this.globalJobDataFactory;
    }

    public void setGlobalJobDataFactory(IGlobalJobDataFactory globalJobDataFactory) {
        this.globalJobDataFactory = globalJobDataFactory;
    }

    public IConnectorPolicyAssignmentPolicy getConnectorPolicyAssignmentPolicy() {
        return this.connectorPolicyAssignmentPolicy;
    }

    public void setConnectorPolicyAssignmentPolicy(IConnectorPolicyAssignmentPolicy connectorPolicyAssignmentPolicy) {
        this.connectorPolicyAssignmentPolicy = connectorPolicyAssignmentPolicy;
    }

    public boolean isUseConnectorPolicyForScheduling() {
        return this.useConnectorPolicyForScheduling;
    }

    public void setUseConnectorPolicyForScheduling(boolean useConnectorPolicyForScheduling) {
        this.useConnectorPolicyForScheduling = useConnectorPolicyForScheduling;
    }

    public boolean isReportTaskDetails() {
        return this.reportTaskDetails;
    }

    public void setReportTaskDetails(boolean reportTaskDetails) {
        this.reportTaskDetails = reportTaskDetails;
    }

    public List<IConnectorDescriptor> getActivityInputs(ActivityId activityId) {
        ActivityCluster ac = this.activityMap.get(activityId);
        return ac.getActivityInputMap().get(activityId);
    }

    public ActivityId getProducerActivity(ConnectorDescriptorId cid) {
        ActivityCluster ac = this.connectorMap.get(cid);
        return ac.getProducerActivity(cid);
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode acgj = om.createObjectNode();
        ArrayNode acl = om.createArrayNode();
        for (ActivityCluster ac : this.activityClusterMap.values()) {
            acl.add(ac.toJSON());
        }
        acgj.put("version", this.version);
        acgj.set("activity-clusters", (JsonNode)acl);
        return acgj;
    }
}

