/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.hyracks.api.client.ClusterControllerInfo;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.client.IHyracksClientInterface;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.client.impl.JobSpecificationActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobInfo;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.api.topology.ClusterTopology;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.ipc.api.RPCInterface;
import org.apache.hyracks.ipc.impl.HyracksClientInterfaceRemoteProxy;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.sockets.PlainSocketChannelFactory;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.InterruptibleAction;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HyracksConnection
implements Closeable,
IHyracksClientConnection {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String ccHost;
    private final int ccPort;
    private final IPCSystem ipc;
    private final IHyracksClientInterface hci;
    private final ClusterControllerInfo ccInfo;
    private volatile boolean running = false;
    private volatile long reqId = 0L;
    private final ExecutorService uninterruptibleExecutor = Executors.newFixedThreadPool(2, r -> new Thread(r, "HyracksConnection Uninterrubtible thread: "));
    private final BlockingQueue<UnInterruptibleRequest<?>> uninterruptibles = new ArrayBlockingQueue(1);

    public HyracksConnection(String ccHost, int ccPort, ISocketChannelFactory socketChannelFactory) throws Exception {
        this.ccHost = ccHost;
        this.ccPort = ccPort;
        RPCInterface rpci = new RPCInterface();
        this.ipc = new IPCSystem(new InetSocketAddress(0), socketChannelFactory, rpci, new JavaSerializationBasedPayloadSerializerDeserializer());
        this.ipc.start();
        this.hci = new HyracksClientInterfaceRemoteProxy(this.ipc.getReconnectingHandle(new InetSocketAddress(ccHost, ccPort)), rpci);
        this.ccInfo = this.hci.getClusterControllerInfo();
        this.uninterruptibleExecutor.execute(new UninterrubtileRequestHandler());
        this.uninterruptibleExecutor.execute(new UninterrubtileHandlerWatcher());
    }

    public HyracksConnection(String ccHost, int ccPort) throws Exception {
        this(ccHost, ccPort, PlainSocketChannelFactory.INSTANCE);
    }

    @Override
    public void close() {
        this.ipc.stop();
    }

    public JobStatus getJobStatus(JobId jobId) throws Exception {
        return this.hci.getJobStatus(jobId);
    }

    public void cancelJob(JobId jobId) throws Exception {
        CancelJobRequest request = new CancelJobRequest(jobId);
        this.uninterruptiblySubmitAndExecute(request);
    }

    public JobId startJob(JobSpecification jobSpec) throws Exception {
        return this.startJob(jobSpec, EnumSet.noneOf(JobFlag.class));
    }

    public JobId startJob(JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        return this.startJob((IActivityClusterGraphGeneratorFactory)jsacggf, jobFlags);
    }

    public void redeployJobSpec(DeployedJobSpecId deployedJobSpecId, JobSpecification jobSpec) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        this.hci.redeployJobSpec(deployedJobSpecId, JavaSerializationUtils.serialize((Serializable)jsacggf));
    }

    public DeployedJobSpecId deployJobSpec(JobSpecification jobSpec) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        return this.deployJobSpec((IActivityClusterGraphGeneratorFactory)jsacggf);
    }

    public void undeployJobSpec(DeployedJobSpecId deployedJobSpecId) throws Exception {
        this.hci.undeployJobSpec(deployedJobSpecId);
    }

    public JobId startJob(DeployedJobSpecId deployedJobSpecId, Map<byte[], byte[]> jobParameters) throws Exception {
        StartDeployedJobRequest request = new StartDeployedJobRequest(deployedJobSpecId, jobParameters);
        return this.interruptiblySubmitAndExecute(request);
    }

    public JobId startJob(IActivityClusterGraphGeneratorFactory acggf, EnumSet<JobFlag> jobFlags) throws Exception {
        return this.startJob(null, acggf, jobFlags);
    }

    public DeployedJobSpecId deployJobSpec(IActivityClusterGraphGeneratorFactory acggf) throws Exception {
        return this.hci.deployJobSpec(JavaSerializationUtils.serialize((Serializable)acggf));
    }

    public NetworkAddress getResultDirectoryAddress() throws Exception {
        return this.hci.getResultDirectoryAddress();
    }

    public void waitForCompletion(JobId jobId) throws Exception {
        try {
            this.hci.waitForCompletion(jobId);
        }
        catch (InterruptedException e) {
            this.cancelJob(jobId);
            throw e;
        }
    }

    public List<IOperatorStats> waitForCompletion(JobId jobId, List<String> statOperatorNames) throws Exception {
        try {
            return this.hci.waitForCompletion(jobId, statOperatorNames);
        }
        catch (InterruptedException e) {
            this.cancelJob(jobId);
            throw e;
        }
    }

    public Map<String, NodeControllerInfo> getNodeControllerInfos() throws HyracksException {
        try {
            return this.hci.getNodeControllersInfo();
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public ClusterTopology getClusterTopology() throws HyracksException {
        try {
            return this.hci.getClusterTopology();
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public DeploymentId deployBinary(List<String> files) throws Exception {
        DeploymentId deploymentId = new DeploymentId(UUID.randomUUID().toString());
        this.deployBinary(deploymentId, files);
        return deploymentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployBinary(DeploymentId deploymentId, List<String> files) throws Exception {
        ArrayList<URL> binaryURLs = new ArrayList<URL>();
        if (files != null && !files.isEmpty()) {
            try (DefaultHttpClient hc = new DefaultHttpClient();){
                for (String file : files) {
                    int slashIndex = file.lastIndexOf(47);
                    String fileName = file.substring(slashIndex + 1);
                    String url = "http://" + this.ccHost + ":" + this.ccInfo.getWebPort() + "/applications/" + deploymentId.toString() + "&" + fileName;
                    HttpPut put = new HttpPut(url);
                    put.setEntity((HttpEntity)new FileEntity(new File(file), "application/octet-stream"));
                    CloseableHttpResponse response = hc.execute((HttpUriRequest)put);
                    response.getEntity().consumeContent();
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.hci.unDeployBinary(deploymentId);
                        throw new HyracksException(response.getStatusLine().toString());
                    }
                    binaryURLs.add(new URL(url));
                }
            }
        }
        this.hci.deployBinary(binaryURLs, deploymentId);
    }

    public void unDeployBinary(DeploymentId deploymentId) throws Exception {
        this.hci.unDeployBinary(deploymentId);
    }

    public JobId startJob(DeploymentId deploymentId, JobSpecification jobSpec) throws Exception {
        return this.startJob(deploymentId, jobSpec, EnumSet.noneOf(JobFlag.class));
    }

    public JobId startJob(DeploymentId deploymentId, JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        return this.startJob(deploymentId, (IActivityClusterGraphGeneratorFactory)jsacggf, jobFlags);
    }

    public JobId startJob(DeploymentId deploymentId, IActivityClusterGraphGeneratorFactory acggf, EnumSet<JobFlag> jobFlags) throws Exception {
        StartJobRequest request = new StartJobRequest(deploymentId, acggf, jobFlags);
        return this.interruptiblySubmitAndExecute(request);
    }

    public JobInfo getJobInfo(JobId jobId) throws Exception {
        return this.hci.getJobInfo(jobId);
    }

    public void stopCluster(boolean terminateNCService) throws Exception {
        this.hci.stopCluster(terminateNCService);
    }

    public String getNodeDetailsJSON(String nodeId, boolean includeStats, boolean includeConfig) throws Exception {
        return this.hci.getNodeDetailsJSON(nodeId, includeStats, includeConfig);
    }

    public String getThreadDump(String node) throws Exception {
        return this.hci.getThreadDump(node);
    }

    public String getHost() {
        return this.ccHost;
    }

    public int getPort() {
        return this.ccPort;
    }

    public boolean isConnected() {
        return this.hci.isConnected();
    }

    private <T> T uninterruptiblySubmitAndExecute(UnInterruptibleRequest<T> request) throws Exception {
        InvokeUtil.doUninterruptibly(() -> this.uninterruptibles.put(request));
        return this.uninterruptiblyExecute(request);
    }

    private <T> T uninterruptiblyExecute(UnInterruptibleRequest<T> request) throws Exception {
        InvokeUtil.doUninterruptibly(request);
        return request.result();
    }

    private <T> T interruptiblySubmitAndExecute(UnInterruptibleRequest<T> request) throws Exception {
        this.uninterruptibles.put(request);
        return this.uninterruptiblyExecute(request);
    }

    private class UninterrubtileRequestHandler
    implements Runnable {
        private UninterrubtileRequestHandler() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            nameBefore = Thread.currentThread().getName();
            Thread.currentThread().setName(nameBefore + this.getClass().getSimpleName());
            try {
                while (true) lbl-1000:
                // 4 sources

                {
                    try {
                        current = HyracksConnection.this.uninterruptibles.take();
                        ++HyracksConnection.this.reqId;
                        HyracksConnection.this.running = true;
                        current.handle();
                    }
                    catch (InterruptedException e) {
                        HyracksConnection.LOGGER.log(Level.WARN, "Ignoring interrupt. This thread should never be interrupted.");
                    }
                    finally {
                        HyracksConnection.this.running = false;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var4_5) {
                Thread.currentThread().setName(nameBefore);
                throw var4_5;
            }
            ** GOTO lbl-1000
        }
    }

    public class UninterrubtileHandlerWatcher
    implements Runnable {
        @Override
        public void run() {
            String nameBefore = Thread.currentThread().getName();
            Thread.currentThread().setName(nameBefore + this.getClass().getSimpleName());
            try {
                long currentReqId = 0L;
                long currentTime = System.nanoTime();
                while (true) {
                    try {
                        TimeUnit.MINUTES.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARN, "Ignoring interrupt. This thread should never be interrupted.");
                        continue;
                    }
                    if (!HyracksConnection.this.running) continue;
                    if (HyracksConnection.this.reqId == currentReqId) {
                        if (TimeUnit.NANOSECONDS.toMinutes(System.nanoTime() - currentTime) <= 0L) continue;
                        ExitUtil.halt((int)5);
                        continue;
                    }
                    currentReqId = HyracksConnection.this.reqId;
                    currentTime = System.nanoTime();
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setName(nameBefore);
                throw throwable;
            }
        }
    }

    private class CancelJobRequest
    extends UnInterruptibleRequest<Void> {
        final JobId jobId;

        public CancelJobRequest(JobId jobId) {
            this.jobId = jobId;
        }

        @Override
        protected Void doHandle() throws Exception {
            HyracksConnection.this.hci.cancelJob(this.jobId);
            return null;
        }

        public String toString() {
            return "CancelJobRequest: " + this.jobId.toString();
        }
    }

    private abstract class UnInterruptibleRequest<T>
    implements InterruptibleAction {
        boolean completed = false;
        boolean failed = false;
        Throwable failure = null;
        T response = null;

        private UnInterruptibleRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handle() {
            try {
                this.response = this.doHandle();
            }
            catch (Throwable th) {
                this.failed = true;
                this.failure = th;
            }
            finally {
                UnInterruptibleRequest unInterruptibleRequest = this;
                synchronized (unInterruptibleRequest) {
                    this.completed = true;
                    this.notifyAll();
                }
            }
        }

        protected abstract T doHandle() throws Exception;

        public final synchronized void run() throws InterruptedException {
            while (!this.completed) {
                this.wait();
            }
        }

        public T result() throws Exception {
            if (this.failed) {
                if (this.failure instanceof Error) {
                    throw (Error)this.failure;
                }
                throw (Exception)this.failure;
            }
            return this.response;
        }
    }

    private class StartDeployedJobRequest
    extends UnInterruptibleRequest<JobId> {
        private final DeployedJobSpecId deployedJobSpecId;
        private final Map<byte[], byte[]> jobParameters;

        public StartDeployedJobRequest(DeployedJobSpecId deployedJobSpecId, Map<byte[], byte[]> jobParameters) {
            this.deployedJobSpecId = deployedJobSpecId;
            this.jobParameters = jobParameters;
        }

        @Override
        protected JobId doHandle() throws Exception {
            return HyracksConnection.this.hci.startJob(this.deployedJobSpecId, this.jobParameters);
        }
    }

    private class StartJobRequest
    extends UnInterruptibleRequest<JobId> {
        private final DeploymentId deploymentId;
        private final IActivityClusterGraphGeneratorFactory acggf;
        private final EnumSet<JobFlag> jobFlags;

        public StartJobRequest(DeploymentId deploymentId, IActivityClusterGraphGeneratorFactory acggf, EnumSet<JobFlag> jobFlags) {
            this.deploymentId = deploymentId;
            this.acggf = acggf;
            this.jobFlags = jobFlags;
        }

        @Override
        protected JobId doHandle() throws Exception {
            if (this.deploymentId == null) {
                return HyracksConnection.this.hci.startJob(JavaSerializationUtils.serialize((Serializable)this.acggf), this.jobFlags);
            }
            return HyracksConnection.this.hci.startJob(this.deploymentId, JavaSerializationUtils.serialize((Serializable)this.acggf), this.jobFlags);
        }

        public String toString() {
            return "StartJobRequest";
        }
    }
}

