/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class ServicesListFileSystemsHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-continuation")
    private String xMsContinuation;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="Content-Type")
    private String contentType;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_REQUEST_ID = HttpHeaderName.fromString((String)"x-ms-request-id");
    private static final HttpHeaderName X_MS_CONTINUATION = HttpHeaderName.fromString((String)"x-ms-continuation");

    public ServicesListFileSystemsHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsRequestId = rawHeaders.getValue(X_MS_REQUEST_ID);
        this.xMsContinuation = rawHeaders.getValue(X_MS_CONTINUATION);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public ServicesListFileSystemsHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public ServicesListFileSystemsHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsContinuation() {
        return this.xMsContinuation;
    }

    public ServicesListFileSystemsHeaders setXMsContinuation(String xMsContinuation) {
        this.xMsContinuation = xMsContinuation;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public ServicesListFileSystemsHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServicesListFileSystemsHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }
}

