/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.serializable.std;

public class BufferSerDeUtil {
    public static double getDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(BufferSerDeUtil.getLong(bytes, offset));
    }

    public static float getFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(BufferSerDeUtil.getInt(bytes, offset));
    }

    public static boolean getBoolean(byte[] bytes, int offset) {
        return bytes[offset] != 0;
    }

    public static int getInt(byte[] bytes, int offset) {
        return ((bytes[offset] & 0xFF) << 24) + ((bytes[offset + 1] & 0xFF) << 16) + ((bytes[offset + 2] & 0xFF) << 8) + ((bytes[offset + 3] & 0xFF) << 0);
    }

    public static long getLong(byte[] bytes, int offset) {
        return ((long)(bytes[offset] & 0xFF) << 56) + ((long)(bytes[offset + 1] & 0xFF) << 48) + ((long)(bytes[offset + 2] & 0xFF) << 40) + ((long)(bytes[offset + 3] & 0xFF) << 32) + ((long)(bytes[offset + 4] & 0xFF) << 24) + ((long)(bytes[offset + 5] & 0xFF) << 16) + ((long)(bytes[offset + 6] & 0xFF) << 8) + ((long)(bytes[offset + 7] & 0xFF) << 0);
    }

    public static void writeBoolean(boolean value, byte[] bytes, int offset) {
        bytes[offset] = value ? (byte)1 : 0;
    }

    public static void writeInt(int value, byte[] bytes, int offset) {
        bytes[offset++] = (byte)(value >> 24);
        bytes[offset++] = (byte)(value >> 16);
        bytes[offset++] = (byte)(value >> 8);
        bytes[offset++] = (byte)value;
    }

    public static void writeLong(long value, byte[] bytes, int offset) {
        bytes[offset++] = (byte)(value >> 56);
        bytes[offset++] = (byte)(value >> 48);
        bytes[offset++] = (byte)(value >> 40);
        bytes[offset++] = (byte)(value >> 32);
        bytes[offset++] = (byte)(value >> 24);
        bytes[offset++] = (byte)(value >> 16);
        bytes[offset++] = (byte)(value >> 8);
        bytes[offset++] = (byte)value;
    }

    public static void writeDouble(double value, byte[] bytes, int offset) {
        long lValue = Double.doubleToLongBits(value);
        BufferSerDeUtil.writeLong(lValue, bytes, offset);
    }

    public static void writeFloat(float value, byte[] bytes, int offset) {
        int iValue = Float.floatToIntBits(value);
        BufferSerDeUtil.writeInt(iValue, bytes, offset);
    }
}

