/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs.dataflow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Serializable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ConfFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] confBytes;

    public ConfFactory(JobConf conf) throws HyracksDataException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            conf.write((DataOutput)dos);
            this.confBytes = bos.toByteArray();
            dos.close();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public synchronized JobConf getConf() throws HyracksDataException {
        try {
            JobConf conf = new JobConf();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.confBytes));
            conf.readFields((DataInput)dis);
            dis.close();
            return conf;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

