/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class JobProfile
implements Writable {
    String user;
    final JobID jobid;
    String jobFile;
    String url;
    String name;
    String queueName;

    public JobProfile() {
        this.jobid = new JobID();
    }

    public JobProfile(String user, org.apache.hadoop.mapreduce.JobID jobid, String jobFile, String url, String name) {
        this(user, jobid, jobFile, url, name, "default");
    }

    public JobProfile(String user, org.apache.hadoop.mapreduce.JobID jobid, String jobFile, String url, String name, String queueName) {
        this.user = user;
        this.jobid = JobID.downgrade(jobid);
        this.jobFile = jobFile;
        this.url = url;
        this.name = name;
        this.queueName = queueName;
    }

    @Deprecated
    public JobProfile(String user, String jobid, String jobFile, String url, String name) {
        this(user, JobID.forName(jobid), jobFile, url, name);
    }

    public String getUser() {
        return this.user;
    }

    public JobID getJobID() {
        return this.jobid;
    }

    @Deprecated
    public String getJobId() {
        return this.jobid.toString();
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (IOException ie) {
            return null;
        }
    }

    public String getJobName() {
        return this.name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void write(DataOutput out) throws IOException {
        this.jobid.write(out);
        Text.writeString((DataOutput)out, (String)this.jobFile);
        Text.writeString((DataOutput)out, (String)this.url);
        Text.writeString((DataOutput)out, (String)this.user);
        Text.writeString((DataOutput)out, (String)this.name);
        Text.writeString((DataOutput)out, (String)this.queueName);
    }

    public void readFields(DataInput in) throws IOException {
        this.jobid.readFields(in);
        this.jobFile = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.url = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.user = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.name = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.queueName = StringInterner.weakIntern((String)Text.readString((DataInput)in));
    }

    static {
        WritableFactories.setFactory(JobProfile.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new JobProfile();
            }
        });
    }
}

