/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.common.exceptions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.ErrorMessageUtil;

public class AlgebricksException
extends Exception
implements IFormattedException {
    private static final long serialVersionUID = 2L;
    public static final int UNKNOWN = 0;
    private final String component;
    private final int errorCode;
    private final Serializable[] params;
    private final String nodeId;
    private final SourceLocation sourceLoc;
    protected transient IError error;
    private volatile transient String msgCache;

    public static AlgebricksException create(ErrorCode error, SourceLocation sourceLoc, Serializable ... params) {
        return new AlgebricksException(error, sourceLoc, params);
    }

    public static AlgebricksException create(ErrorCode error, Serializable ... params) {
        return AlgebricksException.create(error, null, params);
    }

    protected AlgebricksException(IError error, String component, int errorCode, String message, Throwable cause, SourceLocation sourceLoc, String nodeId, Serializable ... params) {
        super(message, cause);
        this.error = error;
        this.component = component;
        this.errorCode = errorCode;
        this.sourceLoc = sourceLoc;
        this.nodeId = nodeId;
        this.params = params;
    }

    @Deprecated
    public AlgebricksException(String message) {
        this((IError)null, "", 0, message, null, null, null, new Serializable[0]);
    }

    @Deprecated
    public AlgebricksException(Throwable cause) {
        this(String.valueOf(cause), cause);
    }

    @Deprecated
    public AlgebricksException(String message, Throwable cause) {
        this((IError)null, "", 0, message, cause, null, null, new Serializable[0]);
    }

    public AlgebricksException(Throwable cause, ErrorCode error, Serializable ... params) {
        this((IError)error, error.component(), error.intValue(), error.errorMessage(), cause, null, null, params);
    }

    public AlgebricksException(ErrorCode error, SourceLocation sourceLoc, Serializable ... params) {
        this((IError)error, error.component(), error.intValue(), error.errorMessage(), null, sourceLoc, null, params);
    }

    public AlgebricksException(ErrorCode error, Serializable ... params) {
        this(error, (SourceLocation)null, params);
    }

    protected AlgebricksException(IError error, Throwable cause, SourceLocation sourceLoc, Serializable ... params) {
        this(error, error.component(), error.intValue(), error.errorMessage(), cause, sourceLoc, null, params);
    }

    public String getComponent() {
        return this.component;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Serializable[] getParams() {
        return this.params;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLoc;
    }

    public Optional<IError> getError() {
        return Optional.ofNullable(this.error);
    }

    @Override
    public String getMessage() {
        if (this.msgCache == null) {
            this.msgCache = ErrorMessageUtil.formatMessage((String)this.component, (int)this.errorCode, (String)super.getMessage(), (SourceLocation)this.sourceLoc, (Serializable[])this.params);
        }
        return this.msgCache;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ErrorMessageUtil.writeObjectWithError((IError)this.error, (ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.error = ErrorMessageUtil.readObjectWithError((ObjectInputStream)in).orElse(null);
    }
}

