/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFiltersJaccard;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class PrefixLenJaccardDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = PrefixLenJaccardDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable lenPtr = new VoidPointable();
                    private final IPointable thresholdPtr = new VoidPointable();
                    private final IScalarEvaluator evalLen;
                    private final IScalarEvaluator evalThreshold;
                    private float similarityThresholdCache;
                    private SimilarityFiltersJaccard similarityFilters;
                    private final AMutableInt32 res;
                    private final ISerializerDeserializer<AInt32> int32Serde;
                    {
                        this.evalLen = args[0].createScalarEvaluator(ctx);
                        this.evalThreshold = args[1].createScalarEvaluator(ctx);
                        this.res = new AMutableInt32(0);
                        this.int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        int offset;
                        this.resultStorage.reset();
                        this.evalLen.evaluate(tuple, this.lenPtr);
                        this.evalThreshold.evaluate(tuple, this.thresholdPtr);
                        if (PointableHelper.checkAndSetMissingOrNull((IPointable)result, (IPointable)this.lenPtr, (IPointable)this.thresholdPtr)) {
                            return;
                        }
                        int length = ATypeHierarchy.getIntegerValue((String)PrefixLenJaccardDescriptor.this.getIdentifier().getName(), (int)0, (byte[])this.lenPtr.getByteArray(), (int)this.lenPtr.getStartOffset());
                        byte[] data = this.thresholdPtr.getByteArray();
                        if (data[offset = this.thresholdPtr.getStartOffset()] != ATypeTag.SERIALIZED_FLOAT_TYPE_TAG) {
                            throw new TypeMismatchException(PrefixLenJaccardDescriptor.this.sourceLoc, PrefixLenJaccardDescriptor.this.getIdentifier(), 1, data[offset], new byte[]{ATypeTag.SERIALIZED_FLOAT_TYPE_TAG});
                        }
                        float similarityThreshold = AFloatSerializerDeserializer.getFloat((byte[])data, (int)(offset + 1));
                        if (similarityThreshold != this.similarityThresholdCache || this.similarityFilters == null) {
                            this.similarityFilters = new SimilarityFiltersJaccard(similarityThreshold);
                        }
                        int prefixLength = this.similarityFilters.getPrefixLength(length);
                        this.res.setValue(prefixLength);
                        try {
                            this.int32Serde.serialize((Object)this.res, this.out);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.PREFIX_LEN_JACCARD;
    }
}

