/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.structures;

import org.apache.hyracks.dataflow.std.structures.AbstractHeap;
import org.apache.hyracks.dataflow.std.structures.IMinHeap;
import org.apache.hyracks.dataflow.std.structures.IResetableComparable;
import org.apache.hyracks.dataflow.std.structures.IResetableComparableFactory;

public class MinHeap
extends AbstractHeap
implements IMinHeap<IResetableComparable> {
    public MinHeap(IResetableComparableFactory factory, int capacity) {
        super(factory, capacity);
    }

    @Override
    protected void bubbleUp(int i) {
        int pid = MinHeap.getParentId(i);
        if (pid != -1 && this.compareTo(pid, i) > 0) {
            this.swap(pid, i);
            this.bubbleUp(pid);
        }
    }

    @Override
    protected void trickleDown(int i) {
        int minChild = this.getMinChild(i);
        if (minChild != -1 && this.compareTo(i, minChild) > 0) {
            this.swap(minChild, i);
            this.trickleDown(minChild);
        }
    }

    @Override
    public void getMin(IResetableComparable result) {
        result.reset(this.entries[0]);
        --this.numEntry;
        if (this.numEntry > 0) {
            this.entries[0].reset(this.entries[this.numEntry]);
            this.trickleDown(0);
        }
    }

    @Override
    public void peekMin(IResetableComparable result) {
        result.reset(this.entries[0]);
    }

    @Override
    public void replaceMin(IResetableComparable newElement) {
        this.entries[0].reset(newElement);
        this.trickleDown(0);
    }
}

