/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.NoVersionAttributeException;
import org.apache.hadoop.fs.s3a.RemoteFileChangedException;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.statistics.ChangeTrackerStatistics;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ChangeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeTracker.class);
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final String CHANGE_REPORTED_BY_S3 = "Change reported by S3";
    private final ChangeDetectionPolicy policy;
    private final String uri;
    private final ChangeTrackerStatistics versionMismatches;
    private String revisionId;

    public ChangeTracker(String uri, ChangeDetectionPolicy policy, ChangeTrackerStatistics versionMismatches, S3ObjectAttributes s3ObjectAttributes) {
        this.policy = (ChangeDetectionPolicy)Preconditions.checkNotNull((Object)policy);
        this.uri = uri;
        this.versionMismatches = versionMismatches;
        this.revisionId = policy.getRevisionId(s3ObjectAttributes);
        if (this.revisionId != null) {
            LOG.debug("Tracker {} has revision ID for object at {}: {}", new Object[]{policy, uri, this.revisionId});
        }
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public ChangeDetectionPolicy.Source getSource() {
        return this.policy.getSource();
    }

    @VisibleForTesting
    public long getVersionMismatches() {
        return this.versionMismatches.getVersionMismatches();
    }

    public boolean maybeApplyConstraint(GetObjectRequest request) {
        if (this.policy.getMode() == ChangeDetectionPolicy.Mode.Server && this.revisionId != null) {
            this.policy.applyRevisionConstraint(request, this.revisionId);
            return true;
        }
        return false;
    }

    public boolean maybeApplyConstraint(CopyObjectRequest request) {
        if (this.policy.getMode() == ChangeDetectionPolicy.Mode.Server && this.revisionId != null) {
            this.policy.applyRevisionConstraint(request, this.revisionId);
            return true;
        }
        return false;
    }

    public boolean maybeApplyConstraint(GetObjectMetadataRequest request) {
        if (this.policy.getMode() == ChangeDetectionPolicy.Mode.Server && this.revisionId != null) {
            this.policy.applyRevisionConstraint(request, this.revisionId);
            return true;
        }
        return false;
    }

    public void processResponse(S3Object object, String operation, long pos) throws PathIOException {
        if (object == null) {
            if (this.revisionId != null) {
                this.versionMismatches.versionMismatchError();
                throw new RemoteFileChangedException(this.uri, operation, String.format("Change reported by S3 during %s at position %s. %s %s was unavailable", new Object[]{operation, pos, this.getSource(), this.getRevisionId()}));
            }
            throw new PathIOException(this.uri, "No data returned from GET request");
        }
        this.processMetadata(object.getObjectMetadata(), operation);
    }

    public void processResponse(CopyResult copyResult) throws PathIOException {
        String newRevisionId = this.policy.getRevisionId(copyResult);
        LOG.debug("Copy result {}: {}", (Object)this.policy.getSource(), (Object)newRevisionId);
        if (newRevisionId == null && this.policy.isRequireVersion()) {
            throw new NoVersionAttributeException(this.uri, String.format("Change detection policy requires %s", new Object[]{this.policy.getSource()}));
        }
    }

    public void processException(SdkBaseException e, String operation) throws RemoteFileChangedException {
        AmazonServiceException serviceException;
        if (e instanceof AmazonServiceException && (serviceException = (AmazonServiceException)((Object)e)).getStatusCode() == 412) {
            this.versionMismatches.versionMismatchError();
            throw new RemoteFileChangedException(this.uri, operation, String.format("Constraints of request were unsatisfiable on %s. Version %s was unavailable", new Object[]{this.getSource(), this.getRevisionId()}), serviceException);
        }
    }

    public void processMetadata(ObjectMetadata metadata, String operation) throws PathIOException {
        String newRevisionId = this.policy.getRevisionId(metadata, this.uri);
        this.processNewRevision(newRevisionId, operation, -1L);
    }

    private void processNewRevision(String newRevisionId, String operation, long pos) throws PathIOException {
        if (newRevisionId == null && this.policy.isRequireVersion()) {
            throw new NoVersionAttributeException(this.uri, String.format("Change detection policy requires %s", new Object[]{this.policy.getSource()}));
        }
        if (this.revisionId == null) {
            LOG.debug("Setting revision ID for object at {}: {}", (Object)this.uri, (Object)newRevisionId);
            this.revisionId = newRevisionId;
        } else if (!this.revisionId.equals(newRevisionId)) {
            LOG.debug("Revision ID changed from {} to {}", (Object)this.revisionId, (Object)newRevisionId);
            ImmutablePair<Boolean, RemoteFileChangedException> pair = this.policy.onChangeDetected(this.revisionId, newRevisionId, this.uri, pos, operation, this.versionMismatches.getVersionMismatches());
            if (((Boolean)pair.left).booleanValue()) {
                this.versionMismatches.versionMismatchError();
            }
            if (pair.right != null) {
                throw (RemoteFileChangedException)((Object)pair.right);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChangeTracker{");
        sb.append(this.policy);
        sb.append(", revisionId='").append(this.revisionId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

