/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IIntrospectingOperator;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.ISelfProfilingNodePushable;
import org.apache.hyracks.api.dataflow.IStatsContainingNodePushable;
import org.apache.hyracks.api.dataflow.ITimedWriter;
import org.apache.hyracks.api.dataflow.ProfiledFrameWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.OperatorStats;
import org.apache.hyracks.api.job.profiling.counters.ICounter;
import org.apache.hyracks.api.rewriter.runtime.SuperActivityOperatorNodePushable;

public class ProfiledOperatorNodePushable
implements IOperatorNodePushable,
IStatsContainingNodePushable {
    private final IOperatorNodePushable op;
    private final Map<Integer, ITimedWriter> inputs;
    private final Map<Integer, ITimedWriter> outputs;
    private final IOperatorStats stats;
    private final ICounter totalTime;

    ProfiledOperatorNodePushable(IOperatorNodePushable op, IOperatorStats stats) {
        this.stats = stats;
        this.op = op;
        this.inputs = new HashMap<Integer, ITimedWriter>();
        this.outputs = new HashMap<Integer, ITimedWriter>();
        this.totalTime = new Counter("totalTime");
    }

    @Override
    public void initialize() throws HyracksDataException {
        ProfiledFrameWriter.timeMethod(this.op::initialize, this.totalTime);
    }

    @Override
    public void deinitialize() throws HyracksDataException {
        long ownTime = this.totalTime.get();
        for (ITimedWriter i : this.inputs.values()) {
            ownTime += i.getTotalTime();
        }
        for (ITimedWriter w : this.outputs.values()) {
            ownTime -= w.getTotalTime();
        }
        this.op.deinitialize();
        this.stats.getTimeCounter().set(ownTime);
    }

    @Override
    public int getInputArity() {
        return this.op.getInputArity();
    }

    @Override
    public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
        if (writer instanceof ITimedWriter) {
            ITimedWriter wrapper = (ITimedWriter)writer;
            if (this.op instanceof ISelfProfilingNodePushable) {
                wrapper.setUpstreamStats(((ISelfProfilingNodePushable)((Object)this.op)).getStats());
            } else {
                wrapper.setUpstreamStats(this.stats);
            }
            this.outputs.put(index, wrapper);
        }
        this.op.setOutputFrameWriter(index, writer, recordDesc);
    }

    @Override
    public IFrameWriter getInputFrameWriter(int index) {
        if (this.inputs.get(index) == null) {
            ProfiledFrameWriter pfw = new ProfiledFrameWriter(this.op.getInputFrameWriter(index));
            this.inputs.put(index, pfw);
            return pfw;
        }
        return this.inputs.get(index);
    }

    @Override
    public String getDisplayName() {
        return this.op.getDisplayName();
    }

    @Override
    public IOperatorStats getStats() {
        return this.stats;
    }

    public static IOperatorNodePushable time(IOperatorNodePushable op, IHyracksTaskContext ctx, ActivityId acId) throws HyracksDataException {
        String name = acId.toString() + " - " + op.getDisplayName();
        IStatsCollector statsCollector = ctx.getStatsCollector();
        OperatorStats stats = new OperatorStats(name, acId.getOperatorDescriptorId().toString());
        if (!(op instanceof ISelfProfilingNodePushable)) {
            statsCollector.add(stats);
        }
        if (op instanceof IIntrospectingOperator) {
            ((IIntrospectingOperator)((Object)op)).setOperatorStats(stats);
        }
        if (op instanceof ISelfProfilingNodePushable) {
            ((ISelfProfilingNodePushable)((Object)op)).addStats(stats);
        }
        if (!(op instanceof ProfiledOperatorNodePushable) && !(op instanceof SuperActivityOperatorNodePushable)) {
            return new ProfiledOperatorNodePushable(op, stats);
        }
        return op;
    }

    public static void onlyAddStats(IOperatorNodePushable op, IHyracksTaskContext ctx, ActivityId acId) throws HyracksDataException {
        String name = acId.toString() + " - " + op.getDisplayName();
        IStatsCollector statsCollector = ctx.getStatsCollector();
        OperatorStats stats = new OperatorStats(name, acId.getOperatorDescriptorId().toString());
        if (op instanceof IIntrospectingOperator) {
            ((IIntrospectingOperator)((Object)op)).setOperatorStats(stats);
            statsCollector.add(stats);
        }
    }
}

