/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.expressions.ConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.LValueConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionCountExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionLocationExpression;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobActivityGraph;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.util.DotFormatBuilder;

public final class DotFormatGenerator {
    public static String generate(JobActivityGraph jobActivityGraph) {
        DotFormatBuilder.Node fromNode;
        String fromClassName;
        String fromFullClassName;
        IActivity activity;
        ActivityId fromActivityId;
        DotFormatBuilder.Node toNode;
        ActivityId toActivityId;
        String toClassName;
        String toFullClassName;
        DotFormatBuilder graphBuilder = new DotFormatBuilder(DotFormatBuilder.StringValue.of("JobActivityGraph"));
        HashSet<ImmutablePair> activitiesPairedSet = new HashSet<ImmutablePair>();
        Map<ActivityId, IActivity> activityMap = jobActivityGraph.getActivityMap();
        Map<ActivityId, List<IConnectorDescriptor>> activityInputMap = jobActivityGraph.getActivityInputMap();
        Map<ActivityId, List<IConnectorDescriptor>> activityOutputMap = jobActivityGraph.getActivityOutputMap();
        for (Map.Entry<ActivityId, IActivity> entry : activityMap.entrySet()) {
            DotFormatBuilder.Edge edge;
            ImmutablePair newPair;
            toFullClassName = entry.getValue().getClass().getName();
            toClassName = toFullClassName.substring(toFullClassName.lastIndexOf(46) + 1);
            toActivityId = entry.getValue().getActivityId();
            toNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(toActivityId.toString()), DotFormatBuilder.StringValue.of(toActivityId.toString() + "-" + toClassName));
            List<IConnectorDescriptor> connectors = activityInputMap.get(entry.getKey());
            if (connectors != null) {
                for (IConnectorDescriptor connector : connectors) {
                    fromActivityId = jobActivityGraph.getProducerActivity(connector.getConnectorId());
                    activity = activityMap.get(fromActivityId);
                    fromFullClassName = activity.getClass().getName();
                    fromClassName = fromFullClassName.substring(fromFullClassName.lastIndexOf(46) + 1);
                    fromNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(fromActivityId.toString()), DotFormatBuilder.StringValue.of(fromActivityId.toString() + "-" + fromClassName));
                    newPair = new ImmutablePair((Object)fromActivityId, (Object)toActivityId);
                    if (activitiesPairedSet.contains(newPair)) continue;
                    activitiesPairedSet.add(newPair);
                    edge = graphBuilder.createEdge(fromNode, toNode);
                    if (!connector.allProducersToAllConsumers()) continue;
                    edge.setDashed().setColor(DotFormatBuilder.Color.BLUE);
                }
            }
            fromActivityId = toActivityId;
            fromNode = toNode;
            connectors = activityOutputMap.get(entry.getKey());
            if (connectors == null) continue;
            for (IConnectorDescriptor connector : connectors) {
                toActivityId = jobActivityGraph.getConsumerActivity(connector.getConnectorId());
                activity = activityMap.get(toActivityId);
                toFullClassName = activity.getClass().getName();
                toClassName = toFullClassName.substring(toFullClassName.lastIndexOf(46) + 1);
                toNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(toActivityId.toString()), DotFormatBuilder.StringValue.of(toActivityId.toString() + "-" + toClassName));
                newPair = new ImmutablePair((Object)fromActivityId, (Object)toActivityId);
                if (activitiesPairedSet.contains(newPair)) continue;
                activitiesPairedSet.add(newPair);
                edge = graphBuilder.createEdge(fromNode, toNode);
                if (!connector.allProducersToAllConsumers()) continue;
                edge.setDashed().setColor(DotFormatBuilder.Color.BLUE);
            }
        }
        Map<ActivityId, Set<ActivityId>> blocked2BlockerMap = jobActivityGraph.getBlocked2BlockerMap();
        for (Map.Entry<ActivityId, Set<ActivityId>> entry : blocked2BlockerMap.entrySet()) {
            IActivity blockedActivity = activityMap.get(entry.getKey());
            toFullClassName = blockedActivity.getClass().getName();
            toClassName = toFullClassName.substring(toFullClassName.lastIndexOf(46) + 1);
            toActivityId = entry.getKey();
            toNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(toActivityId.toString()), DotFormatBuilder.StringValue.of(toActivityId.toString() + "-" + toClassName));
            Iterator<ActivityId> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                ActivityId blockingActivityId;
                fromActivityId = blockingActivityId = iterator.next();
                activity = activityMap.get(fromActivityId);
                fromFullClassName = activity.getClass().getName();
                fromClassName = fromFullClassName.substring(fromFullClassName.lastIndexOf(46) + 1);
                fromNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(fromActivityId.toString()), DotFormatBuilder.StringValue.of(fromActivityId.toString() + "-" + fromClassName));
                ImmutablePair newPair = new ImmutablePair((Object)fromActivityId, (Object)toActivityId);
                if (activitiesPairedSet.contains(newPair)) continue;
                activitiesPairedSet.add(newPair);
                graphBuilder.createEdge(fromNode, toNode).setColor(DotFormatBuilder.Color.RED);
            }
        }
        return graphBuilder.getDotDocument();
    }

    public static String generate(JobSpecification jobSpecification) {
        DotFormatBuilder graphBuilder = new DotFormatBuilder(DotFormatBuilder.StringValue.of("JobSpecification"));
        Map<ConnectorDescriptorId, IConnectorDescriptor> connectorMap = jobSpecification.getConnectorMap();
        Set<Constraint> constraints = jobSpecification.getUserConstraints();
        Map<ConnectorDescriptorId, Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>>> cOp = jobSpecification.getConnectorOperatorMap();
        cOp.forEach((connId, srcAndDest) -> DotFormatGenerator.addToGraph(graphBuilder, constraints, connectorMap, connId, (Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>>)srcAndDest));
        return graphBuilder.getDotDocument();
    }

    private static void addToGraph(DotFormatBuilder graph, Set<Constraint> constraints, Map<ConnectorDescriptorId, IConnectorDescriptor> connMap, ConnectorDescriptorId connId, Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>> srcAndDest) {
        IConnectorDescriptor connector = connMap.get(connId);
        Object edgeLabel = connector.getClass().getName().substring(connector.getClass().getName().lastIndexOf(".") + 1);
        edgeLabel = (String)edgeLabel + "-" + connId;
        IOperatorDescriptor sourceOp = (IOperatorDescriptor)((Pair)srcAndDest.getLeft()).getLeft();
        IOperatorDescriptor destOp = (IOperatorDescriptor)((Pair)srcAndDest.getRight()).getLeft();
        StringBuilder source = new StringBuilder(sourceOp.getClass().getName().substring(sourceOp.getClass().getName().lastIndexOf(".") + 1));
        StringBuilder destination = new StringBuilder(destOp.getClass().getName().substring(destOp.getClass().getName().lastIndexOf(".") + 1));
        for (Constraint constraint : constraints) {
            LValueConstraintExpression lvalue = constraint.getLValue();
            if (lvalue.getTag() == ConstraintExpression.ExpressionTag.PARTITION_COUNT) {
                PartitionCountExpression count = (PartitionCountExpression)lvalue;
                if (count.getOperatorDescriptorId().equals(sourceOp.getOperatorId())) {
                    source.append("\n").append(constraint);
                }
                if (!count.getOperatorDescriptorId().equals(destOp.getOperatorId())) continue;
                destination.append("\n").append(constraint);
                continue;
            }
            if (lvalue.getTag() != ConstraintExpression.ExpressionTag.PARTITION_LOCATION) continue;
            PartitionLocationExpression location = (PartitionLocationExpression)lvalue;
            if (location.getOperatorDescriptorId().equals(sourceOp.getOperatorId())) {
                source.append("\n").append(constraint);
            }
            if (!location.getOperatorDescriptorId().equals(destOp.getOperatorId())) continue;
            destination.append("\n").append(constraint);
        }
        DotFormatBuilder.Node sourceNode = graph.createNode(DotFormatBuilder.StringValue.of(sourceOp.getOperatorId().toString()), DotFormatBuilder.StringValue.of(sourceOp.toString() + "-" + source));
        DotFormatBuilder.Node destinationNode = graph.createNode(DotFormatBuilder.StringValue.of(destOp.getOperatorId().toString()), DotFormatBuilder.StringValue.of(destOp.toString() + "-" + destination));
        graph.createEdge(sourceNode, destinationNode).setLabel(DotFormatBuilder.StringValue.of((String)edgeLabel));
    }
}

