/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import org.apache.asterix.app.message.CancelQueryResponse;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.api.IRequestTracker;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.utils.RequestStatus;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CancelQueryRequest
implements ICcAddressedMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final long reqId;
    private final String uuid;
    private final String contextId;

    public CancelQueryRequest(String nodeId, long reqId, String uuid, String contextId) {
        this.nodeId = nodeId;
        this.reqId = reqId;
        this.uuid = uuid;
        this.contextId = contextId;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        RequestStatus status;
        IRequestTracker requestTracker = appCtx.getRequestTracker();
        IClientRequest req = this.uuid != null ? requestTracker.get(this.uuid) : requestTracker.getByClientContextId(this.contextId);
        String requestId = "";
        if (req == null) {
            LOGGER.log(Level.INFO, "No request found for uuid {} or context id {}", (Object)this.uuid, (Object)this.contextId);
            status = RequestStatus.NOT_FOUND;
        } else if (!req.isCancellable()) {
            status = RequestStatus.REJECTED;
        } else {
            try {
                requestId = req.getId();
                requestTracker.cancel(requestId);
                status = RequestStatus.SUCCESS;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "unexpected exception thrown from cancel", (Throwable)e);
                status = RequestStatus.FAILED;
            }
        }
        LOGGER.debug("sending CancelQueryResponse to {}. reqId:{}, uuid:{}, contextId:{}, status:{}", (Object)this.nodeId, (Object)requestId, (Object)this.uuid, (Object)this.contextId, (Object)status);
        CancelQueryResponse response = new CancelQueryResponse(this.reqId, status);
        CCMessageBroker messageBroker = (CCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        try {
            messageBroker.sendApplicationMessageToNC(response, this.nodeId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure sending response to nc", (Throwable)e);
        }
    }

    public String toString() {
        return "CancelQueryRequest{from='" + this.nodeId + "', reqId=" + this.reqId + ", uuid='" + this.uuid + "', contextId='" + this.contextId + "'}";
    }
}

