/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import java.util.Collection;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.messaging.NCMessageBroker;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.Warning;

public final class ExecuteStatementResponseMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 2L;
    private final long requestMessageId;
    private final String clientContextID;
    private final String uuid;
    private String result;
    private IStatementExecutor.ResultMetadata metadata;
    private IStatementExecutor.Stats stats;
    private IStatementExecutor.StatementProperties statementProperties;
    private Throwable error;
    private ExecutionPlans executionPlans;
    private Collection<Warning> warnings;

    public ExecuteStatementResponseMessage(long requestMessageId, String clientContextID, String uuid) {
        this.requestMessageId = requestMessageId;
        this.clientContextID = clientContextID;
        this.uuid = uuid;
    }

    public void handle(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        NCMessageBroker mb = (NCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        MessageFuture future = mb.deregisterMessageFuture(this.requestMessageId);
        if (future != null) {
            future.complete((Object)this);
        }
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public IStatementExecutor.ResultMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IStatementExecutor.ResultMetadata metadata) {
        this.metadata = metadata;
    }

    public IStatementExecutor.Stats getStats() {
        return this.stats;
    }

    public void setStats(IStatementExecutor.Stats stats) {
        this.stats = stats;
    }

    public IStatementExecutor.StatementProperties getStatementProperties() {
        return this.statementProperties;
    }

    public void setStatementProperties(IStatementExecutor.StatementProperties statementProperties) {
        this.statementProperties = statementProperties;
    }

    public ExecutionPlans getExecutionPlans() {
        return this.executionPlans;
    }

    public void setExecutionPlans(ExecutionPlans executionPlans) {
        this.executionPlans = executionPlans;
    }

    public Collection<Warning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Collection<Warning> warnings) {
        this.warnings = warnings;
    }

    public String toString() {
        return String.format("%s(id=%s, uuid=%s, clientContextId=%s): %d characters", this.getClass().getSimpleName(), this.requestMessageId, this.uuid, this.clientContextID, this.result != null ? this.result.length() : 0);
    }
}

