/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SelectExcludeRewriteSugarVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public SelectExcludeRewriteSugarVisitor(LangRewritingContext langRewritingContext) {
        super(langRewritingContext);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        SelectExpression innerSelectExpr;
        super.visit(selectBlock, arg);
        SelectClause selectClause = selectBlock.getSelectClause();
        if (selectClause.getFieldExclusions().isEmpty()) {
            return null;
        }
        SelectExpression selectExpression = (SelectExpression)arg;
        if (selectBlock.hasFromClause() && selectBlock.getFromClause().getFromTerms().size() == 1) {
            FromTerm fromTerm = selectBlock.getFromClause().getFromTerms().get(0);
            if (!selectBlock.hasGroupbyClause() && !fromTerm.hasCorrelateClauses() && selectBlock.getLetWhereList().stream().noneMatch(c -> c.getClauseType() == Clause.ClauseType.LET_CLAUSE)) {
                SelectRegular selectRegular = selectClause.getSelectRegular();
                if (selectClause.selectRegular() && selectRegular.getProjections().size() == 1 && selectRegular.getProjections().get(0).getKind() == Projection.Kind.STAR) {
                    String fromTermName = fromTerm.getLeftVariable().getVar().getValue();
                    String qualifier = SqlppVariableUtil.toUserDefinedName(fromTermName);
                    selectClause.getFieldExclusions().stream().filter(e -> {
                        Iterator liveSymbolIterator = this.scopeChecker.getCurrentScope().liveSymbols(null);
                        while (liveSymbolIterator.hasNext()) {
                            Pair symbol = (Pair)liveSymbolIterator.next();
                            String symbolName = SqlppVariableUtil.toUserDefinedName(((Identifier)symbol.first).getValue());
                            if (!symbolName.equals(e.get(0))) continue;
                            return false;
                        }
                        return true;
                    }).forEach(e -> e.add(0, qualifier));
                }
            }
        }
        SetOperationInput setOperationInput = null;
        SelectSetOperation selectSetOperation = selectExpression.getSelectSetOperation();
        if (selectBlock.equals((Object)selectSetOperation.getLeftInput().getSelectBlock())) {
            setOperationInput = selectSetOperation.getLeftInput();
        } else {
            for (SetOperationRight rightInput : selectSetOperation.getRightInputs()) {
                SetOperationInput setOperationRightInput = rightInput.getSetOperationRightInput();
                if (!selectBlock.equals((Object)setOperationRightInput.getSelectBlock())) continue;
                setOperationInput = setOperationRightInput;
                break;
            }
        }
        if (setOperationInput == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, selectBlock.getSourceLocation(), new Serializable[]{"Parent SET-OP-INPUT not found while rewriting SELECT-EXCLUDE!"});
        }
        SourceLocation sourceLocation = selectBlock.getSourceLocation();
        SetOperationInput innerSetOpInput = new SetOperationInput(selectBlock, null);
        SelectSetOperation innerSelectSetOp = new SelectSetOperation(innerSetOpInput, null);
        innerSelectSetOp.setSourceLocation(sourceLocation);
        if (!selectSetOperation.hasRightInputs()) {
            SelectExpression selectExprCopy = (SelectExpression)SqlppRewriteUtil.deepCopy((ILangExpression)selectExpression);
            innerSelectExpr = new SelectExpression(selectExprCopy.getLetList(), innerSelectSetOp, selectExprCopy.getOrderbyClause(), selectExprCopy.getLimitClause(), true);
            selectExpression.getLetList().clear();
            selectExpression.setOrderbyClause(null);
            selectExpression.setLimitClause(null);
        } else {
            innerSelectExpr = new SelectExpression(null, innerSelectSetOp, null, null, true);
        }
        innerSelectExpr.setSourceLocation(sourceLocation);
        VarIdentifier fromTermVariable = this.context.newVariable();
        VariableExpr fromTermVariableExpr = new VariableExpr(fromTermVariable);
        SelectClause innerSelectClause = this.buildSelectClause(selectClause, fromTermVariable);
        innerSelectClause.setSourceLocation(sourceLocation);
        FromTerm innerFromTerm = new FromTerm((Expression)innerSelectExpr, fromTermVariableExpr, null, null);
        innerFromTerm.setSourceLocation(sourceLocation);
        FromClause innerFromClause = new FromClause(List.of(innerFromTerm));
        innerFromClause.setSourceLocation(sourceLocation);
        SelectBlock innerSelectBlock = new SelectBlock(innerSelectClause, innerFromClause, null, null, null);
        setOperationInput.setSelectBlock(innerSelectBlock);
        return null;
    }

    private SelectClause buildSelectClause(SelectClause originalSelectClause, VarIdentifier iterationVariable) {
        ListConstructor listConstructor = new ListConstructor();
        listConstructor.setType(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR);
        listConstructor.setExprList(new ArrayList());
        for (List<String> nestedField : originalSelectClause.getFieldExclusions()) {
            if (nestedField.size() == 1) {
                listConstructor.getExprList().add(new LiteralExpr((Literal)new StringLiteral(nestedField.get(0))));
                continue;
            }
            ListConstructor nestedFieldList = new ListConstructor();
            nestedFieldList.setType(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR);
            nestedFieldList.setExprList(nestedField.stream().map(f -> new LiteralExpr((Literal)new StringLiteral(f))).collect(Collectors.toList()));
            listConstructor.getExprList().add(nestedFieldList);
        }
        ArrayList<Object> objectRemoveFieldsArguments = new ArrayList<Object>();
        objectRemoveFieldsArguments.add(new VariableExpr(iterationVariable));
        objectRemoveFieldsArguments.add(listConstructor);
        originalSelectClause.getFieldExclusions().clear();
        boolean isDistinct = originalSelectClause.distinct();
        if (isDistinct) {
            originalSelectClause.setDistinct(false);
        }
        FunctionSignature functionSignature = new FunctionSignature(BuiltinFunctions.REMOVE_FIELDS);
        CallExpr callExpr = new CallExpr(functionSignature, objectRemoveFieldsArguments);
        SelectElement selectElement = new SelectElement((Expression)callExpr);
        SelectClause selectClause = new SelectClause(selectElement, null, isDistinct);
        selectClause.setSourceLocation(originalSelectClause.getSourceLocation());
        return selectClause;
    }
}

