/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.CheckSubqueryVisitor;
import org.apache.asterix.lang.sqlpp.visitor.DeepCopyVisitor;
import org.apache.asterix.lang.sqlpp.visitor.FreeVariableVisitor;
import org.apache.asterix.lang.sqlpp.visitor.SqlppSubstituteExpressionVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;

public class SqlppRewriteUtil {
    private SqlppRewriteUtil() {
    }

    public static Set<VariableExpr> getFreeVariable(Expression expr) throws CompilationException {
        HashSet<VariableExpr> vars = new HashSet<VariableExpr>();
        FreeVariableVisitor visitor = new FreeVariableVisitor();
        expr.accept((ILangVisitor)visitor, vars);
        return vars;
    }

    public static ILangExpression deepCopy(ILangExpression expr) throws CompilationException {
        if (expr == null) {
            return expr;
        }
        DeepCopyVisitor visitor = new DeepCopyVisitor();
        return (ILangExpression)expr.accept((ILangVisitor)visitor, null);
    }

    public static boolean constainsSubquery(ILangExpression expr) throws CompilationException {
        if (expr == null) {
            return false;
        }
        CheckSubqueryVisitor visitor = new CheckSubqueryVisitor();
        return (Boolean)expr.accept((ILangVisitor)visitor, null);
    }

    public static Expression substituteExpression(Expression expression, Map<? extends Expression, Expression> exprMap, LangRewritingContext context) throws CompilationException {
        if (exprMap.isEmpty()) {
            return expression;
        }
        Query wrapper = new Query(false);
        wrapper.setSourceLocation(expression.getSourceLocation());
        wrapper.setBody(expression);
        SqlppSubstituteExpressionVisitor visitor = new SqlppSubstituteExpressionVisitor(context, exprMap);
        wrapper.accept((ILangVisitor)visitor, (Object)wrapper);
        return wrapper.getBody();
    }

    public static Expression getFieldByName(Expression inExpr, String fieldName) {
        LiteralExpr fieldNameExpr = new LiteralExpr((Literal)new StringLiteral(fieldName));
        fieldNameExpr.setSourceLocation(inExpr.getSourceLocation());
        ArrayList<Object> argList = new ArrayList<Object>(2);
        argList.add(inExpr);
        argList.add(fieldNameExpr);
        CallExpr callExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.FIELD_ACCESS_BY_NAME), argList);
        callExpr.setSourceLocation(inExpr.getSourceLocation());
        return callExpr;
    }
}

