/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.clienthelper.commands;

import java.io.IOException;
import org.apache.asterix.clienthelper.Args;
import org.apache.asterix.clienthelper.commands.ClientCommand;

public class SleepCommand
extends ClientCommand {
    public SleepCommand(Args args) {
        super(args);
    }

    @Override
    public int execute() throws IOException {
        int timeoutSecs = this.args.getTimeoutSecs();
        if (timeoutSecs <= 0) {
            throw new IllegalArgumentException("-timeout must be specified and greater than zero");
        }
        this.log("sleeping for " + timeoutSecs + " seconds...");
        try {
            Thread.sleep((long)timeoutSecs * 1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("interrupted during sleep", e);
        }
        this.log("done!");
        return 0;
    }
}

