/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hyracks.storage.am.lsm.invertedindex.api;

import java.nio.ByteBuffer;

public interface IInvertedListSearchResultFrameTupleAppender {

    public void reset(ByteBuffer buffer);

    public void reset(ByteBuffer buffer, boolean clear, int tupleCount, int tupleDataEndOffset);

    public boolean append(byte[] bytes, int offset, int length);

    public boolean append(int fieldValue);

    public boolean append(long fieldValue);

    public boolean append(char fieldValue);

    public boolean append(byte fieldValue);

    // returns true if a tuple of the given length fits, returns false otherwise
    public boolean hasSpace(int length);

    public void incrementTupleCount(int count);

    public int getTupleCount();

    public ByteBuffer getBuffer();

}
