/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.web.util.IJSONOutputFunction;
import org.apache.hyracks.control.cc.web.util.JSONOutputRequestUtil;
import org.apache.hyracks.control.cc.work.GetActivityClusterGraphJSONWork;
import org.apache.hyracks.control.cc.work.GetJobRunJSONWork;
import org.apache.hyracks.control.cc.work.GetJobSummariesJSONWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class JobsRESTAPIFunction
implements IJSONOutputFunction {
    private static final String[] DETAILS = new String[]{"job-run", "job-activity-graph"};
    private ClusterControllerService ccs;

    public JobsRESTAPIFunction(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    @Override
    public ObjectNode invoke(String host, String servletPath, String[] arguments) throws Exception {
        ObjectMapper om = new ObjectMapper();
        ObjectNode result = om.createObjectNode();
        switch (arguments.length) {
            case 1: {
                if (!"".equals(arguments[0])) break;
            }
            case 0: {
                GetJobSummariesJSONWork gjse = new GetJobSummariesJSONWork(this.ccs.getJobManager());
                this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gjse);
                result.set("result", (JsonNode)JobsRESTAPIFunction.enhanceSummaries(gjse.getSummaries(), host, servletPath));
                break;
            }
            case 2: {
                JobId jobId = JobId.parse((String)arguments[0]);
                if ("job-activity-graph".equalsIgnoreCase(arguments[1])) {
                    GetActivityClusterGraphJSONWork gjage = new GetActivityClusterGraphJSONWork(this.ccs, jobId);
                    this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gjage);
                    result.set("result", (JsonNode)gjage.getJSON());
                    break;
                }
                if (!"job-run".equalsIgnoreCase(arguments[1])) break;
                GetJobRunJSONWork gjre = new GetJobRunJSONWork(this.ccs.getJobManager(), jobId);
                this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gjre);
                result.set("result", (JsonNode)gjre.getJSON());
                break;
            }
        }
        return result;
    }

    private static ArrayNode enhanceSummaries(ArrayNode summaries, String host, String servletPath) throws URISyntaxException {
        for (int i = 0; i < summaries.size(); ++i) {
            ObjectNode node = (ObjectNode)summaries.get(i);
            String jid = node.get("job-id").asText();
            for (String field : DETAILS) {
                URI uri = JSONOutputRequestUtil.uri(host, servletPath, jid + "/" + field);
                node.put(field, uri.toString());
            }
        }
        return summaries;
    }
}

