/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.context.ITransactionOperationTracker;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseOperationTracker
implements ITransactionOperationTracker {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final int datasetID;
    protected final DatasetInfo dsInfo;

    public BaseOperationTracker(int datasetID, DatasetInfo dsInfo) {
        this.datasetID = datasetID;
        this.dsInfo = dsInfo;
    }

    public void beforeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.REPLICATE) {
            this.dsInfo.declareActiveIOOperation(ILSMIOOperation.LSMIOOperationType.REPLICATE);
        }
    }

    public void afterOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.REPLICATE) {
            this.completeOperation(index, opType, searchCallback, modificationCallback);
        }
    }

    public void completeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.REPLICATE) {
            this.dsInfo.undeclareActiveIOOperation(ILSMIOOperation.LSMIOOperationType.REPLICATE);
        }
    }

    @Override
    public void beforeTransaction(long resourceId) {
        this.dsInfo.touch();
        IndexInfo indexInfo = this.dsInfo.getIndexes().get(resourceId);
        if (indexInfo == null) {
            LOGGER.error("could not find resource id {} in dataset {}; registered indexes {}", (Object)resourceId, (Object)this.dsInfo, this.dsInfo.getIndexes());
            throw new IllegalStateException("could not find resource id " + resourceId + " in dataset " + this.dsInfo);
        }
        indexInfo.touch();
    }

    @Override
    public void afterTransaction(long resourceId) {
        this.dsInfo.untouch();
        IndexInfo indexInfo = this.dsInfo.getIndexes().get(resourceId);
        if (indexInfo != null) {
            indexInfo.untouch();
        }
    }

    public DatasetInfo getDatasetInfo() {
        return this.dsInfo;
    }
}

