/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.ILSMComponentIdGeneratorFactory;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.common.IResource;

public class DatasetLSMComponentIdGeneratorFactory
implements ILSMComponentIdGeneratorFactory {
    private static final long serialVersionUID = 1L;
    private final int datasetId;

    public DatasetLSMComponentIdGeneratorFactory(int datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public ILSMComponentIdGenerator getComponentIdGenerator(INCServiceContext serviceCtx, IResource resource) throws HyracksDataException {
        IDatasetLifecycleManager dslcManager = ((INcApplicationContext)serviceCtx.getApplicationContext()).getDatasetLifecycleManager();
        int partition = StoragePathUtil.getPartitionNumFromRelativePath(resource.getPath());
        return dslcManager.getComponentIdGenerator(this.datasetId, partition, resource.getPath());
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put("datasetId", this.datasetId);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return new DatasetLSMComponentIdGeneratorFactory(json.get("datasetId").asInt());
    }
}

