/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class OrderOperator
extends AbstractLogicalOperator {
    public static IOrder ASC_ORDER = new IOrder(){

        @Override
        public Mutable<ILogicalExpression> getExpressionRef() {
            return null;
        }

        @Override
        public IOrder.OrderKind getKind() {
            return IOrder.OrderKind.ASC;
        }
    };
    public static IOrder DESC_ORDER = new IOrder(){

        @Override
        public Mutable<ILogicalExpression> getExpressionRef() {
            return null;
        }

        @Override
        public IOrder.OrderKind getKind() {
            return IOrder.OrderKind.DESC;
        }
    };
    private final List<Pair<IOrder, Mutable<ILogicalExpression>>> orderExpressions;
    protected final int topK;

    public OrderOperator() {
        this.orderExpressions = new ArrayList<Pair<IOrder, Mutable<ILogicalExpression>>>();
        this.topK = -1;
    }

    public OrderOperator(List<Pair<IOrder, Mutable<ILogicalExpression>>> orderExpressions) {
        this(orderExpressions, -1);
    }

    public OrderOperator(List<Pair<IOrder, Mutable<ILogicalExpression>>> orderExpressions, int topK) {
        this.orderExpressions = orderExpressions;
        this.topK = topK;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.ORDER;
    }

    public List<Pair<IOrder, Mutable<ILogicalExpression>>> getOrderExpressions() {
        return this.orderExpressions;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList<LogicalVariable>(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.ALL;
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        boolean b = false;
        for (Pair<IOrder, Mutable<ILogicalExpression>> p : this.orderExpressions) {
            FunOrder fo;
            Mutable<ILogicalExpression> r1;
            if (((IOrder)p.first).getKind() == IOrder.OrderKind.FUNCTIONCALL && visitor.transform(r1 = (fo = (FunOrder)p.first).getExpressionRef())) {
                b = true;
            }
            if (!visitor.transform((Mutable<ILogicalExpression>)((Mutable)p.second))) continue;
            b = true;
        }
        return b;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitOrderOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }

    public int getTopK() {
        return this.topK;
    }

    public class FunOrder
    implements IOrder {
        private final Mutable<ILogicalExpression> f;

        public FunOrder(Mutable<ILogicalExpression> f) {
            this.f = f;
        }

        @Override
        public Mutable<ILogicalExpression> getExpressionRef() {
            return this.f;
        }

        @Override
        public IOrder.OrderKind getKind() {
            return IOrder.OrderKind.FUNCTIONCALL;
        }
    }

    public static interface IOrder {
        public Mutable<ILogicalExpression> getExpressionRef();

        public OrderKind getKind();

        public static enum OrderKind {
            FUNCTIONCALL,
            ASC,
            DESC;

        }
    }
}

