/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.rewriter.base;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.rewriter.base.AbstractRuleController;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.Level;

public class HeuristicOptimizer {
    private final IOptimizationContext context;
    private final List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites;
    private final List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites;
    private final ILogicalPlan plan;
    public static final PhysicalOperatorTag[] hyraxOperatorsBelowWhichJobGenIsDisabled = new PhysicalOperatorTag[0];

    public HeuristicOptimizer(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites, IOptimizationContext context) {
        this.plan = plan;
        this.context = context;
        this.logicalRewrites = logicalRewrites;
        this.physicalRewrites = physicalRewrites;
    }

    public void optimize() throws AlgebricksException {
        if (this.plan == null) {
            return;
        }
        this.logPlanAt("Plan Before Optimization", Level.TRACE);
        this.sanityCheckBeforeOptimization(this.plan);
        this.runLogicalOptimizationSets(this.plan, this.logicalRewrites);
        HeuristicOptimizer.computeSchemaBottomUpForPlan(this.plan);
        this.runPhysicalOptimizationSets(this.plan, this.physicalRewrites);
        this.logPlanAt("Plan After Optimization", Level.TRACE);
    }

    private void logPlanAt(String name, Level lvl) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isEnabled(lvl)) {
            String planStr = this.context.getPrettyPrinter().reset().printPlan(this.plan).toString();
            AlgebricksConfig.ALGEBRICKS_LOGGER.log(lvl, name + ":\n" + LogRedactionUtil.userData((String)planStr));
        }
    }

    private void runLogicalOptimizationSets(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> optimizationSet) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace("Starting logical optimizations.\n");
        }
        this.runOptimizationSets(plan, optimizationSet);
    }

    private void runOptimizationSets(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> optimizationSet) throws AlgebricksException {
        for (Pair<AbstractRuleController, List<IAlgebraicRewriteRule>> ruleList : optimizationSet) {
            for (Mutable<ILogicalOperator> r : plan.getRoots()) {
                ((AbstractRuleController)ruleList.first).setContext(this.context);
                ((AbstractRuleController)ruleList.first).rewriteWithRuleCollection(r, (Collection)ruleList.second);
            }
        }
    }

    private static void computeSchemaBottomUpForPlan(ILogicalPlan p) throws AlgebricksException {
        for (Mutable<ILogicalOperator> r : p.getRoots()) {
            HeuristicOptimizer.computeSchemaBottomUpForOp((AbstractLogicalOperator)r.getValue());
        }
    }

    private static void computeSchemaBottomUpForOp(AbstractLogicalOperator op) throws AlgebricksException {
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            HeuristicOptimizer.computeSchemaBottomUpForOp((AbstractLogicalOperator)i.getValue());
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans a = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : a.getNestedPlans()) {
                HeuristicOptimizer.computeSchemaBottomUpForPlan(p);
            }
        }
        op.recomputeSchema();
    }

    private void runPhysicalOptimizationSets(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> optimizationSet) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace("Starting physical optimizations.\n");
        }
        this.runOptimizationSets(plan, optimizationSet);
    }

    private void sanityCheckBeforeOptimization(ILogicalPlan plan) throws AlgebricksException {
        if (this.context.getPhysicalOptimizationConfig().isSanityCheckEnabled()) {
            try {
                for (Mutable<ILogicalOperator> opRef : plan.getRoots()) {
                    this.context.getPlanStructureVerifier().verifyPlanStructure(opRef);
                }
            }
            catch (AlgebricksException e) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{String.format("Initial plan contains illegal %s", e.getMessage())});
            }
        }
    }
}

