/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.OneToOneExchangePOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IsolateHyracksOperatorsRule
implements IAlgebraicRewriteRule {
    private final PhysicalOperatorTag[] operatorsBelowWhichJobGenIsDisabled;

    public IsolateHyracksOperatorsRule(PhysicalOperatorTag[] operatorsBelowWhichJobGenIsDisabled) {
        this.operatorsBelowWhichJobGenIsDisabled = operatorsBelowWhichJobGenIsDisabled;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        IPhysicalOperator pt = op.getPhysicalOperator();
        if (pt == null || op.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
            return false;
        }
        if (!pt.isMicroOperator()) {
            return this.testIfExchangeBelow(opRef, context);
        }
        return this.testIfExchangeAbove(opRef, context);
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    private boolean testIfExchangeBelow(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean exchInserted = false;
        for (Mutable i : op.getInputs()) {
            AbstractLogicalOperator c = (AbstractLogicalOperator)i.getValue();
            if (c.getOperatorTag() == LogicalOperatorTag.EXCHANGE) continue;
            if (c.getPhysicalOperator() == null) {
                return false;
            }
            IsolateHyracksOperatorsRule.insertOneToOneExchange((Mutable<ILogicalOperator>)i, context);
            exchInserted = true;
        }
        IPhysicalOperator pt = op.getPhysicalOperator();
        if (pt.isJobGenDisabledBelowMe() || IsolateHyracksOperatorsRule.arrayContains(this.operatorsBelowWhichJobGenIsDisabled, pt.getOperatorTag())) {
            for (Mutable i : op.getInputs()) {
                this.disableJobGenRec((ILogicalOperator)i.getValue());
            }
        }
        return exchInserted;
    }

    private void disableJobGenRec(ILogicalOperator operator) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)operator;
        op.disableJobGen();
        for (Mutable i : op.getInputs()) {
            this.disableJobGenRec((ILogicalOperator)i.getValue());
        }
    }

    private boolean testIfExchangeAbove(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
            return false;
        }
        boolean exchInserted = false;
        for (Mutable i : op.getInputs()) {
            AbstractLogicalOperator c = (AbstractLogicalOperator)i.getValue();
            IPhysicalOperator cpop = c.getPhysicalOperator();
            if (c.getOperatorTag() == LogicalOperatorTag.EXCHANGE || cpop == null || cpop.isMicroOperator()) continue;
            IsolateHyracksOperatorsRule.insertOneToOneExchange((Mutable<ILogicalOperator>)i, context);
            exchInserted = true;
        }
        return exchInserted;
    }

    private static final <T> boolean arrayContains(T[] array, T tag) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != tag) continue;
            return true;
        }
        return false;
    }

    private static void insertOneToOneExchange(Mutable<ILogicalOperator> inOpRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator inOp = (ILogicalOperator)inOpRef.getValue();
        ExchangeOperator e = new ExchangeOperator();
        e.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
        e.getInputs().add(new MutableObject((Object)inOp));
        e.setExecutionMode(inOp.getExecutionMode());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)e);
        e.recomputeSchema();
        inOpRef.setValue((Object)e);
    }
}

