/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class CompactionPolicy
implements IMetadataEntity<CompactionPolicy> {
    private static final long serialVersionUID = 2L;
    private final DataverseName dataverseName;
    private final String policyName;
    private final String className;

    public CompactionPolicy(DataverseName dataverseName, String policyName, String className) {
        this.dataverseName = dataverseName;
        this.policyName = policyName;
        this.className = className;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompactionPolicy)) {
            return false;
        }
        CompactionPolicy otherPolicy = (CompactionPolicy)other;
        if (!otherPolicy.dataverseName.equals((Object)this.dataverseName)) {
            return false;
        }
        return otherPolicy.policyName.equals(this.policyName);
    }

    @Override
    public CompactionPolicy addToCache(MetadataCache cache) {
        return cache.addCompactionPolicyIfNotExists(this);
    }

    @Override
    public CompactionPolicy dropFromCache(MetadataCache cache) {
        return cache.dropCompactionPolicy(this);
    }
}

