/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.accessors;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class RawBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    public static final IBinaryComparatorFactory INSTANCE = new RawBinaryComparatorFactory();

    private RawBinaryComparatorFactory() {
    }

    public IBinaryComparator createBinaryComparator() {
        return RawBinaryComparatorFactory::compare;
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int commonLength = Math.min(l1, l2);
        for (int i = 0; i < commonLength; ++i) {
            if (b1[s1 + i] == b2[s2 + i]) continue;
            return b1[s1 + i] - b2[s2 + i];
        }
        return Integer.compare(l1, l2);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        return registry.getClassIdentifier(this.getClass(), 1L);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return INSTANCE;
    }
}

