/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.i18n.Messages;

public class XSDListUtils {
    private XSDListUtils() {
    }

    public static String toXSDListString(Object container) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (container != null && container.getClass().isArray()) {
            String xsdString = "";
            for (int i = 0; i < Array.getLength(container); ++i) {
                Object component = Array.get(container, i);
                if (xsdString.length() != 0) {
                    xsdString = xsdString + " ";
                }
                xsdString = xsdString + XSDListUtils.getAsText(component);
            }
            return xsdString;
        }
        if (container != null && List.class.isAssignableFrom(container.getClass())) {
            String xsdString = "";
            List containerAsList = (List)container;
            for (Object component : containerAsList) {
                if (xsdString.length() != 0) {
                    xsdString = xsdString + " ";
                }
                xsdString = xsdString + XSDListUtils.getAsText(component);
            }
            return xsdString;
        }
        throw new IllegalArgumentException(container.getClass().toString());
    }

    public static Object fromXSDListString(String xsdListString, Class type) throws IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ParseException, DatatypeConfigurationException {
        if (type.isArray()) {
            Class boxedType;
            Class componentType = type.getComponentType();
            ArrayList<Object> list = new ArrayList<Object>();
            StringTokenizer st = new StringTokenizer(xsdListString);
            while (st.hasMoreTokens()) {
                String text = st.nextToken();
                Object componentObject = XSDListUtils.getFromText(text, componentType);
                list.add(componentObject);
            }
            Class arrayType = componentType;
            if (componentType.isPrimitive() && (boxedType = XSDListUtils.getBoxedType(componentType)) != null) {
                arrayType = boxedType;
            }
            Object array = Array.newInstance(arrayType, list.size());
            return list.toArray((Object[])array);
        }
        throw new IllegalArgumentException(type.toString());
    }

    public static Object fromStringArray(String[] items, Class type) throws Exception {
        if (type.isArray()) {
            Class boxedType;
            Class componentType = type.getComponentType();
            ArrayList<Object> list = new ArrayList<Object>();
            for (String item : items) {
                Object componentObject = XSDListUtils.getFromText(item, componentType);
                list.add(componentObject);
            }
            Class arrayType = componentType;
            if (componentType.isPrimitive() && (boxedType = XSDListUtils.getBoxedType(componentType)) != null) {
                arrayType = boxedType;
            }
            Object array = Array.newInstance(arrayType, list.size());
            return list.toArray((Object[])array);
        }
        throw new IllegalArgumentException(type.toString());
    }

    public static String[] toStringArraay(Object container) throws Exception {
        if (container != null && container.getClass().isArray()) {
            int size = Array.getLength(container);
            String[] strArray = new String[size];
            for (int i = 0; i < size; ++i) {
                Object component = Array.get(container, i);
                strArray[i] = XSDListUtils.getAsText(component);
            }
            return strArray;
        }
        if (container != null && List.class.isAssignableFrom(container.getClass())) {
            List containerAsList = (List)container;
            int size = containerAsList.size();
            String[] strArray = new String[size];
            for (int i = 0; i < size; ++i) {
                strArray[i] = XSDListUtils.getAsText(containerAsList.get(i));
            }
            return strArray;
        }
        throw new IllegalArgumentException(container.getClass().toString());
    }

    private static String getAsText(Object obj) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (obj instanceof QName) {
            throw new RuntimeException(Messages.getMessage((String)"XSDListNotSupported", (String)QName.class.getName()));
        }
        if (obj instanceof XMLGregorianCalendar) {
            throw new RuntimeException(Messages.getMessage((String)"XSDListNotSupported", (String)XMLGregorianCalendar.class.getName()));
        }
        if (obj.getClass().isEnum()) {
            Method method = obj.getClass().getDeclaredMethod("value", new Class[0]);
            return (String)method.invoke(obj, new Object[0]);
        }
        return obj.toString();
    }

    private static Object getFromText(String value, Class componentType) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ParseException, DatatypeConfigurationException {
        if (componentType == String.class) {
            return value;
        }
        if (componentType.isEnum()) {
            Method method = componentType.getDeclaredMethod("fromValue", String.class);
            Object obj = method.invoke(null, value);
            return obj;
        }
        if (componentType == Byte.TYPE) {
            componentType = Byte.class;
        }
        if (componentType == Short.TYPE) {
            componentType = Short.class;
        }
        if (componentType == Integer.TYPE) {
            componentType = Integer.class;
        }
        if (componentType == Float.TYPE) {
            componentType = Float.class;
        }
        if (componentType == Double.TYPE) {
            componentType = Double.class;
        }
        if (componentType == Character.TYPE) {
            Character ch = null;
            if (value != null && value.length() > 0) {
                ch = Character.valueOf(value.charAt(0));
            }
            return ch;
        }
        if (componentType == Boolean.TYPE) {
            componentType = Boolean.class;
        }
        if (componentType.equals(QName.class)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"XSDListNotSupported", (String)componentType.getName()));
        }
        if (componentType.equals(XMLGregorianCalendar.class)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"XSDListNotSupported", (String)componentType.getName()));
        }
        Constructor constructor = componentType.getConstructor(String.class);
        Object obj = constructor.newInstance(value);
        return obj;
    }

    private static Class getBoxedType(Class primitiveType) {
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        return null;
    }

    private static GregorianCalendar toGregorianCalendar(String value) throws ParseException {
        Date d = new SimpleDateFormat().parse(value);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(d);
        return gc;
    }
}

