/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.moshi;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.json.factory.JSONType;
import org.apache.axis2.json.factory.JsonObject;
import org.apache.axis2.json.factory.XmlNode;
import org.apache.axis2.json.factory.XmlNodeGenerator;
import org.apache.axis2.json.moshi.MoshiNamespaceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;

public class MoshiXMLStreamWriter
implements XMLStreamWriter {
    Log log = LogFactory.getLog(MoshiXMLStreamWriter.class);
    private JsonWriter jsonWriter;
    private Queue<JsonObject> queue = new LinkedList<JsonObject>();
    private Stack<JsonObject> stack = new Stack();
    private Stack<JsonObject> miniStack = new Stack();
    private JsonObject flushObject;
    private JsonObject topNestedArrayObj;
    private Stack<JsonObject> processedJsonObjects = new Stack();
    private List<XmlSchema> xmlSchemaList;
    private QName elementQName;
    private XmlNode mainXmlNode;
    private ConfigurationContext configContext;
    private XmlNodeGenerator xmlNodeGenerator;
    private boolean isProcessed;
    private Map<String, String> uriPrefixMap = new HashMap<String, String>();

    public MoshiXMLStreamWriter(JsonWriter jsonWriter, QName elementQName, List<XmlSchema> xmlSchemaList, ConfigurationContext context) {
        this.jsonWriter = jsonWriter;
        this.elementQName = elementQName;
        this.xmlSchemaList = xmlSchemaList;
        this.configContext = context;
    }

    private void process() throws IOException {
        Object ob = this.configContext.getProperty("xmlnodes");
        if (ob != null) {
            Map nodeMap = (Map)ob;
            XmlNode resNode = (XmlNode)nodeMap.get(this.elementQName);
            if (resNode != null) {
                this.xmlNodeGenerator = new XmlNodeGenerator();
                this.queue = this.xmlNodeGenerator.getQueue(resNode);
            } else {
                this.xmlNodeGenerator = new XmlNodeGenerator(this.xmlSchemaList, this.elementQName);
                this.mainXmlNode = this.xmlNodeGenerator.getMainXmlNode();
                this.queue = this.xmlNodeGenerator.getQueue(this.mainXmlNode);
                nodeMap.put(this.elementQName, this.mainXmlNode);
                this.configContext.setProperty("xmlnodes", (Object)nodeMap);
            }
        } else {
            HashMap<QName, XmlNode> newNodeMap = new HashMap<QName, XmlNode>();
            this.xmlNodeGenerator = new XmlNodeGenerator(this.xmlSchemaList, this.elementQName);
            this.mainXmlNode = this.xmlNodeGenerator.getMainXmlNode();
            this.queue = this.xmlNodeGenerator.getQueue(this.mainXmlNode);
            newNodeMap.put(this.elementQName, this.mainXmlNode);
            this.configContext.setProperty("xmlnodes", newNodeMap);
        }
        this.isProcessed = true;
        this.jsonWriter.beginObject();
        this.log.debug((Object)"MoshiXMLStreamWriter.process() completed");
    }

    private void writeStartJson(JsonObject jsonObject) throws IOException {
        if (jsonObject.getType() == JSONType.OBJECT) {
            this.jsonWriter.name(jsonObject.getName());
        } else if (jsonObject.getType() == JSONType.ARRAY) {
            this.jsonWriter.name(jsonObject.getName());
            this.jsonWriter.beginArray();
        } else if (jsonObject.getType() == JSONType.NESTED_ARRAY) {
            this.jsonWriter.name(jsonObject.getName());
            this.jsonWriter.beginArray();
            this.jsonWriter.beginObject();
            if (this.topNestedArrayObj == null) {
                this.topNestedArrayObj = jsonObject;
                this.processedJsonObjects.push(jsonObject);
            }
        } else if (jsonObject.getType() == JSONType.NESTED_OBJECT) {
            this.jsonWriter.name(jsonObject.getName());
            this.jsonWriter.beginObject();
        }
    }

    private void writeEndJson(JsonObject endJson) throws IOException {
        if (endJson.getType() != JSONType.OBJECT) {
            if (endJson.getType() == JSONType.ARRAY) {
                this.jsonWriter.endArray();
            } else if (endJson.getType() == JSONType.NESTED_ARRAY) {
                this.jsonWriter.endArray();
            } else if (endJson.getType() == JSONType.NESTED_OBJECT) {
                this.jsonWriter.endObject();
            }
        }
    }

    private JsonObject popStack() {
        if (this.topNestedArrayObj == null || this.stack.peek().getType() == JSONType.NESTED_OBJECT || this.stack.peek().getType() == JSONType.NESTED_ARRAY) {
            return this.stack.pop();
        }
        this.processedJsonObjects.push(this.stack.peek());
        return this.stack.pop();
    }

    private void fillMiniStack(JsonObject nestedJsonObject) {
        while (!this.processedJsonObjects.peek().getName().equals(nestedJsonObject.getName())) {
            this.miniStack.push(this.processedJsonObjects.pop());
        }
        this.processedJsonObjects.pop();
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        block21: {
            if (!this.isProcessed) {
                try {
                    this.process();
                }
                catch (IOException e) {
                    throw new XMLStreamException("Error occours while write first begin object ");
                }
            }
            JsonObject stackObj = null;
            try {
                if (this.miniStack.isEmpty()) {
                    if (!this.queue.isEmpty()) {
                        JsonObject queObj = this.queue.peek();
                        if (queObj.getName().equals(localName)) {
                            if (this.flushObject != null) {
                                if (this.topNestedArrayObj != null && this.flushObject.getType() == JSONType.NESTED_ARRAY && this.flushObject.getName().equals(this.topNestedArrayObj.getName())) {
                                    this.topNestedArrayObj = null;
                                    this.processedJsonObjects.clear();
                                }
                                this.popStack();
                                this.writeEndJson(this.flushObject);
                                this.flushObject = null;
                            }
                            if (this.topNestedArrayObj != null && (queObj.getType() == JSONType.NESTED_ARRAY || queObj.getType() == JSONType.NESTED_OBJECT)) {
                                this.processedJsonObjects.push(queObj);
                            }
                            this.writeStartJson(queObj);
                            this.stack.push(this.queue.poll());
                            break block21;
                        }
                        if (this.stack.isEmpty()) break block21;
                        stackObj = this.stack.peek();
                        if (stackObj.getName().equals(localName)) {
                            if (stackObj.getType() == JSONType.NESTED_ARRAY) {
                                this.fillMiniStack(stackObj);
                                this.jsonWriter.beginObject();
                                this.processedJsonObjects.push(stackObj);
                            }
                            this.flushObject = null;
                            break block21;
                        }
                        throw new XMLStreamException("Invalid Staring element");
                    }
                    if (!this.stack.isEmpty()) {
                        stackObj = this.stack.peek();
                        if (stackObj.getName().equals(localName)) {
                            this.flushObject = null;
                            if (stackObj.getType() == JSONType.NESTED_ARRAY) {
                                this.fillMiniStack(stackObj);
                                this.jsonWriter.beginObject();
                                this.processedJsonObjects.push(stackObj);
                            }
                            break block21;
                        }
                        throw new XMLStreamException("Invalid Staring element");
                    }
                    throw new XMLStreamException("Invalid Starting  element");
                }
                JsonObject queObj = this.miniStack.peek();
                if (queObj.getName().equals(localName)) {
                    if (this.flushObject != null) {
                        this.popStack();
                        this.writeEndJson(this.flushObject);
                        this.flushObject = null;
                    }
                    if (this.topNestedArrayObj != null && (queObj.getType() == JSONType.NESTED_OBJECT || queObj.getType() == JSONType.NESTED_ARRAY)) {
                        this.processedJsonObjects.push(queObj);
                    }
                    this.writeStartJson(queObj);
                    this.stack.push(this.miniStack.pop());
                    break block21;
                }
                if (this.stack.isEmpty()) break block21;
                stackObj = this.stack.peek();
                if (stackObj.getName().equals(localName)) {
                    this.flushObject = null;
                    if (stackObj.getType() == JSONType.NESTED_ARRAY) {
                        this.fillMiniStack(stackObj);
                        this.jsonWriter.beginObject();
                        this.processedJsonObjects.push(stackObj);
                    }
                    break block21;
                }
                throw new XMLStreamException("Invalid Staring element");
            }
            catch (IOException ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new XMLStreamException("Bad Response");
            }
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occours while write first begin object ");
            }
        }
        try {
            if (this.flushObject != null) {
                if (this.topNestedArrayObj != null && this.flushObject.getType() == JSONType.NESTED_ARRAY && this.flushObject.equals(this.topNestedArrayObj.getName())) {
                    this.topNestedArrayObj = null;
                    this.processedJsonObjects.clear();
                }
                this.popStack();
                this.writeEndJson(this.flushObject);
                this.flushObject = null;
                this.writeEndElement();
            } else if (this.stack.peek().getType() == JSONType.ARRAY) {
                this.flushObject = this.stack.peek();
            } else if (this.stack.peek().getType() == JSONType.NESTED_ARRAY) {
                this.flushObject = this.stack.peek();
                this.jsonWriter.endObject();
            } else {
                JsonObject stackObj = this.popStack();
                this.writeEndJson(stackObj);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Json writer throw an exception");
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occours while write first begin object ");
            }
        }
        if (this.queue.isEmpty() && this.stack.isEmpty()) {
            try {
                if (this.flushObject != null) {
                    this.writeEndJson(this.flushObject);
                }
                this.jsonWriter.endObject();
                this.jsonWriter.flush();
                this.jsonWriter.close();
            }
            catch (IOException e) {
                throw new XMLStreamException("JsonWriter threw an exception", e);
            }
        } else {
            throw new XMLStreamException("Invalid xml element");
        }
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.jsonWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error occur while closing JsonWriter");
        }
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occur while write first begin object ");
            }
        }
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occur while trying to write start document element", e);
            }
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occur while trying to write first begin object ", e);
            }
        }
        try {
            JsonObject peek = this.stack.peek();
            String valueType = peek.getValueType();
            if (valueType.equals("string")) {
                this.jsonWriter.value(text);
            } else if (valueType.equals("int")) {
                Integer num = new Integer(text);
                this.jsonWriter.value((Number)num);
            } else if (valueType.equals("long")) {
                this.jsonWriter.value((Number)Long.valueOf(text));
            } else if (valueType.equals("double")) {
                this.jsonWriter.value((Number)Double.valueOf(text));
            } else if (valueType.equals("boolean")) {
                this.jsonWriter.value(Boolean.valueOf(text));
            } else {
                this.jsonWriter.value(text);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("JsonWriter throw an exception");
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.uriPrefixMap.get(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.uriPrefixMap.put(uri, prefix);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new MoshiNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }
}

