/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.i18n.Messages;

public class InOnlyAxisOperation
extends AxisOperation {
    private AxisMessage inFaultMessage;
    private AxisMessage outFaultMessage;
    private ArrayList outPhase;

    public InOnlyAxisOperation() {
        QName tmpName = new QName(this.getClass().getName() + "_" + UIDGenerator.generateUID());
        this.setName(tmpName);
        this.createMessage();
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-only");
    }

    public InOnlyAxisOperation(QName name) {
        super(name);
        this.createMessage();
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-only");
    }

    @Override
    public OperationClient createClient(ServiceContext sc, Options options) {
        throw new UnsupportedOperationException(Messages.getMessage("mepnotyetimplemented", this.mepURI));
    }

    @Override
    public void addMessage(AxisMessage message, String label) {
        if (!"In".equals(label)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.addChild("inMessage", message);
    }

    @Override
    public void addMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        if (opContext.isComplete()) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        opContext.getMessageContexts().put("In", msgContext);
        opContext.setComplete(true);
    }

    @Override
    public void addFaultMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        HashMap<String, MessageContext> mep = opContext.getMessageContexts();
        MessageContext faultMessageCtxt = mep.get("Fault");
        if (faultMessageCtxt != null) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        mep.put("Fault", msgContext);
        opContext.setComplete(true);
        opContext.cleanup();
    }

    private void createMessage() {
        AxisMessage inMessage = new AxisMessage();
        inMessage.setDirection("in");
        inMessage.setParent(this);
        this.inFaultMessage = new AxisMessage();
        this.inFaultMessage.setParent(this);
        this.outFaultMessage = new AxisMessage();
        this.outFaultMessage.setParent(this);
        this.outPhase = new ArrayList();
        this.addChild("inMessage", inMessage);
    }

    @Override
    public AxisMessage getMessage(String label) {
        if ("In".equals(label)) {
            return (AxisMessage)this.getChild("inMessage");
        }
        throw new UnsupportedOperationException(Messages.getMessage("invalidacess"));
    }

    @Override
    public ArrayList getPhasesInFaultFlow() {
        return this.inFaultMessage.getMessageFlow();
    }

    @Override
    public ArrayList getPhasesOutFaultFlow() {
        return this.outFaultMessage.getMessageFlow();
    }

    @Override
    public ArrayList getPhasesOutFlow() {
        return this.outPhase;
    }

    @Override
    public ArrayList getRemainingPhasesInFlow() {
        return ((AxisMessage)this.getChild("inMessage")).getMessageFlow();
    }

    @Override
    public void setPhasesInFaultFlow(ArrayList list) {
        this.inFaultMessage.setMessageFlow(list);
    }

    @Override
    public void setPhasesOutFaultFlow(ArrayList list) {
        this.outFaultMessage.setMessageFlow(list);
    }

    @Override
    public void setPhasesOutFlow(ArrayList list) {
        this.outPhase = list;
    }

    @Override
    public void setRemainingPhasesInFlow(ArrayList list) {
        ((AxisMessage)this.getChild("inMessage")).setMessageFlow(list);
    }
}

