/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream;

import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlHandlerWrapper;
import org.apache.axiom.om.impl.common.AxiomSemantics;

public class XsiTypeFilterHandler
extends XmlHandlerWrapper {
    private final CoreElement contextElement;
    private String[] prefixes = new String[16];
    private int prefixCount;
    private int[] scopeStack = new int[8];
    private int scopes;
    private String xsiType;

    public XsiTypeFilterHandler(XmlHandler parent, CoreElement contextElement) {
        super(parent);
        this.contextElement = contextElement;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        super.startElement(namespaceURI, localName, prefix);
        if (this.scopes == this.scopeStack.length) {
            int[] newScopeStack = new int[this.scopeStack.length * 2];
            System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
            this.scopeStack = newScopeStack;
        }
        this.scopeStack[this.scopes++] = this.prefixCount;
    }

    @Override
    public void endElement() throws StreamException {
        this.prefixCount = this.scopeStack[--this.scopes];
        super.endElement();
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        super.processNamespaceDeclaration(prefix, namespaceURI);
        if (this.prefixes.length == this.prefixCount) {
            String[] newPrefixes = new String[this.prefixes.length * 2];
            System.arraycopy(this.prefixes, 0, newPrefixes, 0, this.prefixes.length);
            this.prefixes = newPrefixes;
        }
        this.prefixes[this.prefixCount++] = prefix;
    }

    @Override
    public void processAttribute(String namespaceURI, String localName, String prefix, String value, String type, boolean specified) throws StreamException {
        super.processAttribute(namespaceURI, localName, prefix, value, type, specified);
        if (namespaceURI.equals("http://www.w3.org/2001/XMLSchema-instance") && localName.equals("type")) {
            this.xsiType = value.trim();
        }
    }

    @Override
    public void attributesCompleted() throws StreamException {
        try {
            if (this.xsiType != null) {
                String namespaceURI;
                int idx = this.xsiType.indexOf(58);
                String prefix = idx == -1 ? "" : this.xsiType.substring(0, idx);
                boolean bound = false;
                for (int i = 0; i < this.prefixCount; ++i) {
                    if (this.prefixes[i] != prefix) continue;
                    bound = true;
                    break;
                }
                if (!bound && (namespaceURI = this.contextElement.coreLookupNamespaceURI(prefix, AxiomSemantics.INSTANCE)) != null && !namespaceURI.isEmpty()) {
                    this.processNamespaceDeclaration(prefix, namespaceURI);
                }
            }
        }
        catch (CoreModelException ex) {
            throw new StreamException(ex);
        }
        super.attributesCompleted();
        this.xsiType = null;
    }
}

