/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.AbstractServiceBuilderExtension;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDLServiceBuilderExtension
extends AbstractServiceBuilderExtension {
    private static Log log = LogFactory.getLog(WSDLServiceBuilderExtension.class);

    @Override
    public Map<String, AxisService> buildAxisServices(DeploymentFileData deploymentFileData) throws DeploymentException {
        ArchiveReader archiveReader = new ArchiveReader();
        HashMap<String, AxisService> wsdlservices = archiveReader.processWSDLs(deploymentFileData);
        if (wsdlservices != null && wsdlservices.size() > 0) {
            for (AxisService service : wsdlservices.values()) {
                Iterator<AxisOperation> operations = service.getOperations();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = operations.next();
                    try {
                        this.getConfigurationContext().getAxisConfiguration().getPhasesInfo().setOperationPhases(axisOperation);
                    }
                    catch (AxisFault e) {
                        throw new DeploymentException(e);
                    }
                }
            }
        }
        return wsdlservices;
    }
}

