/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.stax.pull;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.core.stream.CharacterData;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.stax.pull.input.DTDInfo;
import org.apache.axiom.core.stream.stax.pull.input.XMLStreamReaderHelper;
import org.apache.axiom.ext.stax.BlobReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;

final class AxiomXMLStreamReaderHelper
extends XMLStreamReaderHelper {
    private final XMLStreamReader reader;
    private final BlobReader blobReader;

    AxiomXMLStreamReaderHelper(XMLStreamReader reader) {
        this.reader = reader;
        this.blobReader = XMLStreamReaderUtils.getBlobReader((XMLStreamReader)reader);
    }

    @Override
    public DTDInfo getDTDInfo() throws StreamException {
        DTDReader dtdReader;
        try {
            dtdReader = (DTDReader)this.reader.getProperty(DTDReader.PROPERTY);
        }
        catch (IllegalArgumentException ex) {
            dtdReader = null;
        }
        if (dtdReader == null) {
            throw new StreamException("Cannot process DTD events because the XMLStreamReader doesn't support the DTDReader extension");
        }
        return new DTDInfo(dtdReader.getRootName(), dtdReader.getPublicId(), dtdReader.getSystemId());
    }

    @Override
    public CharacterData getCharacterData() throws StreamException {
        if (this.blobReader != null && this.blobReader.isBinary()) {
            if (this.blobReader.isDeferred()) {
                return new TextContent(this.blobReader.getContentID(), this.blobReader.getBlobProvider(), this.blobReader.isOptimized());
            }
            try {
                return new TextContent(this.blobReader.getContentID(), this.blobReader.getBlob(), this.blobReader.isOptimized());
            }
            catch (XMLStreamException ex) {
                throw new StreamException(ex);
            }
        }
        return null;
    }
}

