/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.impl.httpclient5;

import java.net.URL;
import javax.net.ssl.SSLContext;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.AxisRequestEntity;
import org.apache.axis2.transport.http.HTTPSender;
import org.apache.axis2.transport.http.Request;
import org.apache.axis2.transport.http.impl.httpclient5.RequestImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;

public class HTTPSenderImpl
extends HTTPSender {
    private static final Log log = LogFactory.getLog(HTTPSenderImpl.class);

    @Override
    protected Request createRequest(MessageContext msgContext, String methodName, URL url, AxisRequestEntity requestEntity) throws AxisFault {
        try {
            RequestImpl requestImpl = new RequestImpl(this.getHttpClient(msgContext), msgContext, methodName, url.toURI(), requestEntity);
            return requestImpl;
        }
        catch (Exception ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient getHttpClient(MessageContext msgContext) {
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        HttpClient httpClient = (HttpClient)msgContext.getProperty("CACHED_HTTP_CLIENT");
        if (httpClient == null) {
            httpClient = (HttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
        }
        if (httpClient != null) {
            return httpClient;
        }
        HTTPSenderImpl hTTPSenderImpl = this;
        synchronized (hTTPSenderImpl) {
            httpClient = (HttpClient)msgContext.getProperty("CACHED_HTTP_CLIENT");
            if (httpClient == null) {
                httpClient = (HttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
            }
            if (httpClient != null) {
                return httpClient;
            }
            HttpClientConnectionManager connManager = (HttpClientConnectionManager)msgContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
            if (connManager == null) {
                connManager = (HttpClientConnectionManager)msgContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
            }
            if (connManager == null) {
                ConfigurationContext configurationContext = configContext;
                synchronized (configurationContext) {
                    connManager = (HttpClientConnectionManager)configContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
                    if (connManager == null) {
                        Timeout socketTO;
                        log.trace((Object)"Making new ConnectionManager");
                        SSLContext sslContext = (SSLContext)configContext.getProperty(SSLContext.class.getName());
                        if (sslContext == null) {
                            sslContext = SSLContexts.createDefault();
                        }
                        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
                        Integer tempSoTimeoutProperty = (Integer)msgContext.getProperty("SO_TIMEOUT");
                        Integer tempConnTimeoutProperty = (Integer)msgContext.getProperty("CONNECTION_TIMEOUT");
                        long timeout = msgContext.getOptions().getTimeOutInMilliSeconds();
                        Timeout connectTO = tempConnTimeoutProperty != null ? Timeout.ofMilliseconds((long)tempConnTimeoutProperty.intValue()) : Timeout.ofMinutes((long)3L);
                        if (tempSoTimeoutProperty != null) {
                            socketTO = Timeout.ofMilliseconds((long)tempSoTimeoutProperty.intValue());
                        } else if (timeout > 0L) {
                            socketTO = Timeout.ofMilliseconds((long)timeout);
                        } else {
                            log.error((Object)("Invalid timeout value detected: " + timeout + " , using 3 minute default"));
                            socketTO = Timeout.ofMilliseconds((long)180000L);
                        }
                        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(socketTO).build();
                        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(connectTO).build();
                        Http1Config http1Config = Http1Config.custom().setMaxHeaderCount(500).setMaxLineLength(4000).setMaxEmptyLineCount(1).build();
                        ManagedHttpClientConnectionFactory connFactory = new ManagedHttpClientConnectionFactory(http1Config, CharCodingConfig.DEFAULT, (HttpMessageWriterFactory)new DefaultHttpRequestWriterFactory(), (HttpMessageParserFactory)new DefaultHttpResponseParserFactory(http1Config));
                        connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, (HttpConnectionFactory)connFactory);
                        ((PoolingHttpClientConnectionManager)connManager).setMaxTotal(200);
                        ((PoolingHttpClientConnectionManager)connManager).setDefaultMaxPerRoute(200);
                        ((PoolingHttpClientConnectionManager)connManager).setDefaultSocketConfig(socketConfig);
                        ((PoolingHttpClientConnectionManager)connManager).setDefaultConnectionConfig(connectionConfig);
                        configContext.setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)connManager);
                    }
                }
            }
            return HttpClientBuilder.create().setConnectionManager(connManager).setConnectionManagerShared(true).build();
        }
    }
}

